<?php
namespace App\Http\Controllers;

use App\Models\User;

class AdminController extends Controller
{
    /**
     * Display admin dashboard
     */
    public function index()
    {
        // Gather statistics
        $stats = [
            'total_users'    => User::where('role', 'user')->count(),
            'total_admins'   => User::where('role', 'admin')->count(),
            'total_orders'   => 0, // Will be updated when you create Order model
            'total_products' => 0, // Will be updated when you create Product model
        ];

        return view('admin-dashboard', compact('stats'));
    }

    public function manageOrder()
    {
        return view('admin-order');
    }
}
