<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Http\Request;

class HomeController extends Controller
{
     /**
     * Display the homepage with dynamic products and categories
     */
    public function index()
    {
        // Get all active categories with product count
        $categories = Category::withCount('products')
            ->orderBy('name')
            ->get();

        // Get featured products (you can add is_featured column later)
        $featuredProducts = Product::with(['category', 'images'])
            ->latest()
            ->take(8)
            ->get();

        // Get products by specific categories for tabs
        // Get first two categories for the tabs
        $drugCategory = Category::where('name', 'LIKE', '%drug%')
            ->orWhere('name', 'LIKE', '%medicine%')
            ->first();

        $weightLossCategory = Category::where('name', 'LIKE', '%weight%')
            ->orWhere('name', 'LIKE', '%loss%')
            ->first();

        // Get products for each tab category
        $drugProducts = $drugCategory
            ? Product::with(['category', 'images'])
                ->where('category_id', $drugCategory->id)
                ->take(12)
                ->get()
            : collect();

        $weightLossProducts = $weightLossCategory
            ? Product::with(['category', 'images'])
                ->where('category_id', $weightLossCategory->id)
                ->take(12)
                ->get()
            : collect();

        // Get best selling products (by created_at for now, later use sales count)
        $bestSellingProducts = Product::with(['category', 'images'])
            ->latest()
            ->take(8)
            ->get();

        // Get products for small product list
        $smallProducts = Product::with(['category', 'images'])
            ->latest()
            ->take(9)
            ->get();

        return view('welcome', compact(
            'categories',
            'featuredProducts',
            'drugCategory',
            'weightLossCategory',
            'drugProducts',
            'weightLossProducts',
            'bestSellingProducts',
            'smallProducts'
        ));
    }
}
