<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CryptoWallet;
use App\Models\GiftCard;

class PaymentMethodController extends Controller
{
    public function index()
    {
        $cryptoWallets = CryptoWallet::latest()->get();
        return view('payment-method', compact('cryptoWallets', ));
    }

    // ── Crypto ───────────────────────────────────────────────────────────────
    public function cryptoStore(Request $request)
    {
        $request->validate([
            'currency' => 'required|string',
            'network'  => 'required|string',
            'address'  => 'required|string',
        ]);

        CryptoWallet::create([
            'currency'    => $request->currency,
            'network'     => $request->network,
            'address'     => $request->address,
            'badge_color' => $request->badge_color ?? '#f7931a',
            'is_active'   => $request->has('is_active'),
        ]);

        return back()->with('success', 'Crypto wallet added successfully.');
    }

    public function cryptoUpdate(Request $request)
    {
        $wallet = CryptoWallet::findOrFail($request->id);
        $wallet->update([
            'currency'    => $request->currency,
            'network'     => $request->network,
            'address'     => $request->address,
            'badge_color' => $request->badge_color,
            'is_active'   => $request->has('is_active'),
        ]);

        return back()->with('success', 'Crypto wallet updated.');
    }

    public function cryptoDestroy($id)
    {
        CryptoWallet::findOrFail($id)->delete();
        return back()->with('success', 'Crypto wallet deleted.');
    }

    // ── Gift Cards ───────────────────────────────────────────────────────────



}
