<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;

class AppServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        //
    }

    public function boot(): void
    {
        view()->composer(['layouts.guest', 'layouts.app'], function ($view) {
            $cartCount = 0;
            $cartTotal = 0.0;

            try {
                if (auth()->check()) {
                    // Detect the correct foreign key column on cart_items
                    $columns = Schema::getColumnListing('cart_items');

                    if (in_array('user_id', $columns)) {
                        // Direct user_id on cart_items
                        $items = \App\Models\CartItem::where('user_id', auth()->id())
                            ->with('product')->get();

                    } elseif (in_array('cart_id', $columns)) {
                        // cart_items belongs to a carts table
                        $cartIds = \DB::table('carts')
                            ->where('user_id', auth()->id())
                            ->pluck('id');

                        $items = \App\Models\CartItem::whereIn('cart_id', $cartIds)
                            ->with('product')->get();

                    } elseif (in_array('session_id', $columns)) {
                        // Session-based cart — nothing to show for logged-in users here
                        $items = collect();

                    } else {
                        $items = collect();
                    }

                    $cartCount = $items->sum('quantity');
                    $cartTotal = $items->sum(function ($item) {
                        if (!$item->product) return 0;
                        $price = $item->product->is_on_sale && $item->product->discount_price
                            ? $item->product->discount_price
                            : $item->product->price;
                        return $item->quantity * $price;
                    });
                }
            } catch (\Exception $e) {
                // Fail silently — cart badge just shows 0
                $cartCount = 0;
                $cartTotal = 0.0;
            }

            $view->with([
                'cartCount' => $cartCount,
                'cartTotal' => $cartTotal,
            ]);
        });
    }
}
