<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id(); // Primary key

            // Foreign key linking product to category
            $table->foreignId('category_id')
                  ->constrained() // references id on categories table
                  ->onDelete('cascade'); // delete products if category is deleted

            $table->string('name'); // Product name
            $table->string('slug')->unique(); // SEO URL

            $table->decimal('price', 10, 2); // Product price
            $table->decimal('discount_price', 10, 2)->nullable(); // Fixed typo from 'diccoun_price'

            $table->timestamps(); // created_at & updated_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
