<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            // Crypto fields (add only if they don't exist)
            if (!Schema::hasColumn('orders', 'wallet_id')) {
                $table->unsignedBigInteger('wallet_id')->nullable()->after('status');
            }
            if (!Schema::hasColumn('orders', 'transaction_id')) {
                $table->string('transaction_id')->nullable()->after('wallet_id');
            }
            if (!Schema::hasColumn('orders', 'payment_screenshot')) {
                $table->string('payment_screenshot')->nullable()->after('transaction_id');
            }

            // Gift card fields
            if (!Schema::hasColumn('orders', 'gift_card_brand')) {
                $table->string('gift_card_brand')->nullable()->after('payment_screenshot');
            }
            if (!Schema::hasColumn('orders', 'gift_card_code')) {
                $table->string('gift_card_code')->nullable()->after('gift_card_brand');
            }
            if (!Schema::hasColumn('orders', 'gift_card_pin')) {
                $table->string('gift_card_pin')->nullable()->after('gift_card_code');
            }
            if (!Schema::hasColumn('orders', 'gift_card_value')) {
                $table->decimal('gift_card_value', 10, 2)->nullable()->after('gift_card_pin');
            }
            if (!Schema::hasColumn('orders', 'gift_card_photo')) {
                $table->string('gift_card_photo')->nullable()->after('gift_card_value');
            }
            if (!Schema::hasColumn('orders', 'gift_card_notes')) {
                $table->text('gift_card_notes')->nullable()->after('gift_card_photo');
            }
        });
    }

    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn([
                'wallet_id', 'transaction_id', 'payment_screenshot',
                'gift_card_brand', 'gift_card_code', 'gift_card_pin',
                'gift_card_value', 'gift_card_photo', 'gift_card_notes',
            ]);
        });
    }
};
