@extends('layouts.guest')

@section('content')

<div class="ltn__breadcrumb-area text-left bg-overlay-white-30 bg-image" data-bs-bg="{{ asset('img/bg/14.jpg') }}">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="ltn__breadcrumb-inner">
                    <h1 class="page-title">Confirm Password</h1>
                    <div class="ltn__breadcrumb-list">
                        <ul>
                            <li><a href="{{ route('home') }}"><span class="ltn__secondary-color"><i class="fas fa-home"></i></span> Home</a></li>
                            <li>Confirm Password</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="ltn__login-area pb-80 pt-60">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-5 col-md-7 col-sm-10">
                <div style="background:#fff; padding:40px; border-radius:12px; box-shadow:0 0 30px rgba(0,0,0,0.08);">

                    <div class="text-center mb-4">
                        <div style="width:65px;height:65px;background:rgba(10,154,115,0.1);border-radius:50%;display:flex;align-items:center;justify-content:center;margin:0 auto 15px;">
                            <i class="fas fa-shield-alt" style="font-size:26px;color:#0a9a73;"></i>
                        </div>
                        <h4 class="mb-1" style="font-weight:700;color:#2c3e50;">Secure Area</h4>
                        <p class="text-muted" style="font-size:14px;line-height:1.6;">
                            This is a secure area of the application. Please confirm your password before continuing.
                        </p>
                    </div>

                    @if($errors->any())
                        <div class="alert alert-danger mb-4" style="border-radius:8px;font-size:14px;">
                            <ul class="mb-0 ps-3">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('password.confirm') }}">
                        @csrf

                        <div class="input-item mb-4">
                            <label for="password" style="font-weight:600;font-size:14px;color:#2c3e50;margin-bottom:6px;display:block;">
                                <i class="fas fa-lock me-1" style="color:#0a9a73;"></i> Password
                            </label>
                            <input
                                id="password"
                                type="password"
                                name="password"
                                required
                                autocomplete="current-password"
                                placeholder="Enter your current password"
                                class="form-control @error('password') is-invalid @enderror"
                                style="height:50px;border-radius:8px;border:1px solid #ddd;padding:0 16px;font-size:14px;"
                            >
                        </div>

                        <button
                            type="submit"
                            class="btn w-100 fw-bold"
                            style="background:#0a9a73;color:#fff;height:50px;border-radius:8px;font-size:15px;transition:all 0.3s;"
                            onmouseover="this.style.background='#088a65'"
                            onmouseout="this.style.background='#0a9a73'"
                        >
                            <i class="fas fa-check me-2"></i> Confirm Password
                        </button>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

@endsection
