@extends('layouts.guest')

@section('content')

   <!-- BREADCRUMB AREA START -->
    <div class="ltn__breadcrumb-area text-left bg-overlay-white-30 bg-image" data-bs-bg="img/bg/14.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ltn__breadcrumb-inner">
                        <h1 class="page-title">Account</h1>
                        <div class="ltn__breadcrumb-list">
                            <ul>
                                <li><a href="{{ url('/') }}"><span class="ltn__secondary-color"><i class="fas fa-home"></i></span> Home</a></li>
                                <li>{{ $isAdminRegistration ?? false ? 'Admin Registration' : 'Register' }}</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- BREADCRUMB AREA END -->

    <!-- LOGIN AREA START (Register) -->
    <div class="ltn__login-area pb-110">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-title-area text-center">
                        <h1 class="section-title">
                            {{ $isAdminRegistration ?? false ? 'Admin Registration' : 'Register' }} <br>Your Account
                        </h1>
                        <p>
                            @if($isAdminRegistration ?? false)
                                Create your administrator account to manage the platform.
                            @else
                                Lorem ipsum dolor, sit amet consectetur adipisicing elit. <br>
                                Sit aliquid, Non distinctio vel iste.
                            @endif
                        </p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 offset-lg-3">
                    <div class="account-login-inner">

                        <!-- Admin Registration Alert -->
                        @if($isAdminRegistration ?? false)
                            <div class="alert alert-info mb-4 text-center" style="background-color: #d1ecf1; border-color: #bee5eb; padding: 15px; border-radius: 5px;">
                                <i class="fas fa-shield-alt" style="font-size: 24px; color: #0c5460;"></i>
                                <h5 style="margin: 10px 0 5px 0; color: #0c5460;">Administrator Registration</h5>
                                <p style="margin: 0; color: #0c5460;">You are registering as an <strong>Administrator</strong> with full access rights.</p>
                            </div>
                        @endif

                        <!-- Display Validation Errors -->
                        @if ($errors->any())
                            <div class="alert alert-danger mb-4">
                                <ul style="margin: 0; padding-left: 20px;">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form method="POST" action="{{ route('register') }}" class="ltn__form-box contact-form-box">
                            @csrf

                        @foreach ($errors->all() as $error)
                            <p class="text-danger text-center">{{ $error }}</p>
                        @endforeach
                            <!-- Hidden role field for admin registration -->
                            @if($isAdminRegistration ?? false)
                                <input type="hidden" name="role" value="admin">
                            @endif

                            <!-- Name -->
                            <input type="text"
                                   name="name"
                                   placeholder="Full Name*"
                                   value="{{ old('name') }}"
                                   required>

                            <!-- Email -->
                            <input type="email"
                                   name="email"
                                   placeholder="Email*"
                                   value="{{ old('email') }}"
                                   required>

                            <!-- Password -->
                            <input type="password"
                                   name="password"
                                   placeholder="Password*"
                                   required>
                            <small class="text-muted" style="display: block; margin-top: -10px; margin-bottom: 15px; font-size: 12px;">
                                Minimum 8 characters with uppercase, lowercase, numbers & symbols
                            </small>

                            <!-- Confirm Password -->
                            <input type="password"
                                   name="password_confirmation"
                                   placeholder="Confirm Password*"
                                   required>

                            <!-- Consent Checkboxes -->
                            <label class="checkbox-inline">
                                <input type="checkbox" required>
                                I consent to Notrace Trip processing my personal data in order to send personalized marketing material in accordance with the consent form and the privacy policy.
                            </label>
                            <label class="checkbox-inline">
                                <input type="checkbox" required>
                                By clicking "create account", I consent to the privacy policy.
                            </label>

                            <!-- Submit Button -->
                            <div class="btn-wrapper">
                                <button class="theme-btn-1 btn reverse-color btn-block" type="submit">
                                    {{ $isAdminRegistration ?? false ? 'CREATE ADMIN ACCOUNT' : 'CREATE ACCOUNT' }}
                                </button>
                            </div>
                        </form>

                        <!-- Login Link -->
                        <div class="by-agree text-center">
                            <div class="go-to-btn mt-50">
                                <a href="{{ route('login') }}">ALREADY HAVE AN ACCOUNT?</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- LOGIN AREA END -->

@endsection
