<!doctype html>
<html class="no-js" lang="zxx">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Notrace Trip</title>
    <meta name="robots" content="noindex, follow" />
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="{{ asset('img/favicon.png') }}" type="image/x-icon" />
    <link rel="stylesheet" href="{{ asset('css/font-icons.css') }}">
    <link rel="stylesheet" href="{{ asset('css/plugins.css') }}">
    <link rel="stylesheet" href="{{ asset('css/style.css') }}">
    <link rel="stylesheet" href="{{ asset('css/responsive.css') }}">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        .logout-btn { background: none; border: none; padding: 0; color: red; cursor: pointer; }
        .logout-btn:hover { color: darkred; }
        .ltn__utilize-mobile-menu.ltn__utilize-open { opacity: 1 !important; visibility: visible !important; transform: translateX(0) !important; }
        .ltn__utilize-mobile-menu { position: fixed; top: 0; left: 0; width: 320px; height: 100%; background: #fff; z-index: 9999; transform: translateX(-100%); transition: all 0.3s ease; }
        .ltn__utilize-menu ul { list-style: none; padding: 0; margin: 20px 0; }
        .ltn__utilize-menu ul li { border-bottom: 1px solid #f0f0f0; }
        .ltn__utilize-menu ul li a { display: block; padding: 15px 30px; color: #333; text-decoration: none; font-size: 16px; }
        .ltn__utilize-menu ul li a:hover { background: #f8f8f8; color: #0a9a73; }
        .ltn__utilize-overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9998; opacity: 0; visibility: hidden; transition: all 0.3s ease; }
        .ltn__utilize-overlay.ltn__utilize-open { opacity: 1 !important; visibility: visible !important; }
        .cart-plus-minus { position: relative; width: 120px; height: 50px; overflow: hidden; display: inline-block; }
        .cart-plus-minus .cart-plus-minus-box { width: 100%; height: 100%; border: 1px solid #e1e1e1; text-align: center; font-size: 16px; font-weight: 500; color: #333; background: #fff; padding: 0 40px; }
        .cart-plus-minus .qtybutton { position: absolute; top: 0; width: 35px; height: 100%; border: none; background: #f8f8f8; color: #333; cursor: pointer; font-size: 18px; font-weight: 600; transition: all 0.3s ease; }
        .cart-plus-minus .qtybutton:hover { background: #0a9a73; color: #fff; }
        .cart-plus-minus .inc { right: 0; }
        .cart-plus-minus .dec { left: 0; }
        .modal-product-info h3, .modal-product-info h5 { color: #0a9a73; margin-bottom: 15px; }
        .modal-product-info .product-price { font-size: 24px; font-weight: 700; color: #0a9a73; margin: 15px 0; }
        .modal-product-info .product-price del { font-size: 18px; color: #999; margin-left: 10px; }
        .added-cart { color: #0a9a73; font-weight: 600; margin: 20px 0; }
        .added-cart i { margin-right: 5px; }
        #quick_view_modal .modal-dialog { max-width: 900px; }
        #quick_view_modal .modal-product-img img { width: 100%; height: auto; border-radius: 5px; }
        .modal-product-meta ul { list-style: none; padding: 0; margin: 20px 0; }
        .modal-product-meta ul li { margin-bottom: 10px; font-size: 14px; }
        .modal-product-meta strong { color: #333; margin-right: 10px; }
        .ltn__product-details-menu-2 ul { display: flex; gap: 15px; align-items: center; flex-wrap: wrap; }
        .ltn__product-details-menu-3 ul { display: flex; gap: 20px; }
        .ltn__product-details-menu-3 a { display: flex; align-items: center; gap: 8px; color: #666; transition: color 0.3s ease; text-decoration: none; }
        .ltn__product-details-menu-3 a:hover { color: #0a9a73; }
        .modal-product-img-gallery { width: 100%; position: relative; }
        .modal-product-img-main { width: 100%; height: 400px; border: 1px solid #e1e1e1; border-radius: 8px; overflow: hidden; margin-bottom: 15px; background: #f8f8f8; display: flex; align-items: center; justify-content: center; position: relative; }
        .modal-product-img-main img { width: 100%; height: 100%; object-fit: contain; cursor: zoom-in; }
        .modal-img-arrow { position: absolute; top: 50%; transform: translateY(-50%); background: rgba(255,255,255,0.9); border: 1px solid #e1e1e1; width: 40px; height: 40px; border-radius: 50%; display: flex; align-items: center; justify-content: center; cursor: pointer; transition: all 0.3s ease; z-index: 10; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
        .modal-img-arrow:hover { background: #0a9a73; color: white; border-color: #0a9a73; box-shadow: 0 4px 12px rgba(10,154,115,0.3); }
        .modal-img-arrow.disabled { opacity: 0.3; cursor: not-allowed; pointer-events: none; }
        .modal-img-arrow-prev { left: 10px; }
        .modal-img-arrow-next { right: 10px; }
        .modal-img-arrow i { font-size: 18px; }
        .modal-img-counter { position: absolute; bottom: 10px; right: 10px; background: rgba(0,0,0,0.7); color: white; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; z-index: 10; }
        .modal-product-img-thumbnails { display: flex; gap: 10px; flex-wrap: wrap; justify-content: center; }
        .modal-thumbnail { width: 70px; height: 70px; border: 2px solid #e1e1e1; border-radius: 5px; overflow: hidden; cursor: pointer; transition: all 0.3s ease; background: #fff; }
        .modal-thumbnail:hover, .modal-thumbnail.active { border-color: #0a9a73; transform: scale(1.05); box-shadow: 0 2px 8px rgba(10,154,115,0.3); }
        .modal-thumbnail img { width: 100%; height: 100%; object-fit: cover; }
        #quick-view-stock { color: #0a9a73; font-weight: 600; }
        #quick-view-stock.out-of-stock { color: #ff5722; }
    </style>
</head>
<body>
    <div class="body-wrapper">

        <header class="ltn__header-area ltn__header-3">
            <div class="ltn__header-top-area border-bottom">
                <div class="container">
                    <div class="row">
                        <div class="col-md-7">
                            <div class="ltn__top-bar-menu">
                                <ul>
                                    @auth
                                        <li><a href="mailto:{{ Auth::user()->email }}"><i class="icon-mail"></i> {{ Auth::user()->email }}</a></li>
                                    @endauth
                                    <li><a href="#"><i class="icon-placeholder"></i> 15/A, Nest Tower, NYC</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="top-bar-right text-right text-end">
                                <div class="ltn__top-bar-menu">
                                    <ul>
                                        <li>
                                            <div class="ltn__social-media"><ul>
                                                <li><a href="#" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
                                                <li><a href="#" title="Twitter"><i class="fab fa-twitter"></i></a></li>
                                                <li><a href="#" title="Instagram"><i class="fab fa-instagram"></i></a></li>
                                                <li><a href="#" title="Dribbble"><i class="fab fa-dribbble"></i></a></li>
                                            </ul></div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="ltn__header-middle-area">
                <div class="container">
                    <div class="row">
                        <div class="col">
                            <div class="site-logo">
                                <a href="{{ route('home') }}"><img src="{{ asset('img/ntc_logo.png') }}" alt="Logo"></a>
                            </div>
                        </div>
                        <div class="col header-contact-serarch-column d-none d-lg-block">
                            <div class="header-contact-search">
                                <div class="header-feature-item">
                                    <div class="header-feature-icon"><i class="icon-call"></i></div>
                                    <div class="header-feature-info"><h6>Phone</h6><p><a href="tel:0123456789">+0123-456-789</a></p></div>
                                </div>
                                <div class="header-search-2">
                                    <form method="get" action="{{ route('shop') }}">
                                        <input type="text" name="search" placeholder="Search here..." />
                                        <button type="submit"><span><i class="icon-search"></i></span></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="ltn__header-options">
                                <ul>
                                    <li class="d-lg-none">
                                        <div class="header-search-wrap">
                                            <div class="header-search-1">
                                                <div class="search-icon">
                                                    <i class="icon-search for-search-show"></i>
                                                    <i class="icon-cancel for-search-close"></i>
                                                </div>
                                            </div>
                                            <div class="header-search-1-form">
                                                <form method="get" action="{{ route('shop') }}">
                                                    <input type="text" name="search" placeholder="Search here..." />
                                                    <button type="submit"><span><i class="icon-search"></i></span></button>
                                                </form>
                                            </div>
                                        </div>
                                    </li>
                                    <li class="d-none---">
                                        <div class="ltn__drop-menu user-menu">
                                            <ul>
                                                <li>
                                                    <i class="icon-user"></i>
                                                    <ul>
                                                        @auth
                                                            <li>{{ Auth::user()->name }}</li>
                                                            <li><a href="#">Profile</a></li>
                                                            <li><a href="#">Orders</a></li>
                                                            <li><a href="#">Wishlist</a></li>
                                                            <li>
                                                                <form method="POST" action="{{ route('logout') }}">
                                                                    @csrf
                                                                    <button type="submit" class="logout-btn">Logout</button>
                                                                </form>
                                                            </li>
                                                        @else
                                                            <li><a href="{{ route('login') }}">Login</a></li>
                                                        @endauth
                                                    </ul>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="mini-cart-icon mini-cart-icon-2">
                                            <a href="{{ route('cart.index') }}" class="ltn__utilize-toggle">
                                                <span class="mini-cart-icon">
                                                    <i class="icon-shopping-cart"></i>
                                                    <sup>0</sup>
                                                </span>
                                                <h6><span>Your Cart</span> <span class="ltn__secondary-color">$0.00</span></h6>
                                            </a>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="header-bottom-area ltn__border-top ltn__header-sticky ltn__sticky-bg-secondary ltn__secondary-bg section-bg-1 menu-color-white d-none d-lg-block">
                <div class="container">
                    <div class="row">
                        <div class="col header-menu-column justify-content-center">
                            <div class="sticky-logo">
                                <div class="site-logo">
                                    <a href="{{ route('home') }}"><img src="{{ asset('img/ntgreen.jpeg') }}" alt="Logo"></a>
                                </div>
                            </div>
                            <div class="header-menu header-menu-2">
                                <nav>
                                    <div class="ltn__main-menu">
                                        <ul>
                                            <li><a href="{{ route('dashboard') }}">Home</a></li>
                                            <li><a href="#">About</a></li>
                                            <li><a href="{{ route('shop') }}">Shop</a></li>
                                            <li><a href="#">Weight Loss</a></li>
                                            <li><a href="#">Contact</a></li>
                                        </ul>
                                    </div>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <div class="mobile-header-menu-fullwidth mb-30 d-block d-lg-none">
            <div class="container"><div class="row"><div class="col-lg-12">
                <div class="mobile-menu-toggle d-lg-none">
                    <span>MENU</span>
                    <a href="#ltn__utilize-mobile-menu" class="ltn__utilize-toggle">
                        <svg viewBox="0 0 800 600">
                            <path d="M300,220 C300,220 520,220 540,220 C740,220 640,540 520,420 C440,340 300,200 300,200" id="top"></path>
                            <path d="M300,320 L540,320" id="middle"></path>
                            <path d="M300,210 C300,210 520,210 540,210 C740,210 640,530 520,410 C440,330 300,190 300,190" id="bottom" transform="translate(480, 320) scale(1, -1) translate(-480, -318)"></path>
                        </svg>
                    </a>
                </div>
            </div></div></div>
        </div>

        <div id="ltn__utilize-mobile-menu" class="ltn__utilize ltn__utilize-mobile-menu">
            <div class="ltn__utilize-menu-inner ltn__scrollbar">
                <div class="ltn__utilize-menu-head">
                    <div class="site-logo"><a href="{{ route('home') }}"><img src="{{ asset('img/logo.png') }}" alt="Logo"></a></div>
                    <button class="ltn__utilize-close">×</button>
                </div>
                <div class="ltn__utilize-menu-search-form">
                    <form action="{{ route('shop') }}" method="GET">
                        <input type="text" name="search" placeholder="Search...">
                        <button type="submit"><i class="fas fa-search"></i></button>
                    </form>
                </div>
                <div class="ltn__utilize-menu">
                    <ul>
                        <li><a href="{{ route('home') }}">Home</a></li>
                        <li><a href="#">About</a></li>
                        <li><a href="{{ route('shop') }}">Shop</a></li>
                        <li><a href="#">Weight Loss</a></li>
                        <li><a href="#">Contact</a></li>
                    </ul>
                </div>
                <div class="ltn__utilize-buttons ltn__utilize-buttons-2">
                    <ul>
                        <li><a href="#" title="My Account"><span class="utilize-btn-icon"><i class="far fa-user"></i></span> My Account</a></li>
                        <li><a href="#" title="Wishlist"><span class="utilize-btn-icon"><i class="far fa-heart"></i><sup>0</sup></span> Wishlist</a></li>
                        <li><a href="#" title="Shopping Cart"><span class="utilize-btn-icon"><i class="fas fa-shopping-cart"></i><sup>0</sup></span> Shopping Cart</a></li>
                    </ul>
                </div>
                <div class="ltn__social-media-2">
                    <ul>
                        <li><a href="#" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
                        <li><a href="#" title="Twitter"><i class="fab fa-twitter"></i></a></li>
                        <li><a href="#" title="Linkedin"><i class="fab fa-linkedin"></i></a></li>
                        <li><a href="#" title="Instagram"><i class="fab fa-instagram"></i></a></li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="ltn__utilize-overlay"></div>

        @yield('content')

        <footer class="ltn__footer-area">
            <div class="footer-top-area section-bg-2 plr--5">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xl-3 col-md-6 col-sm-6 col-12">
                            <div class="footer-widget footer-about-widget">
                                <div class="footer-logo"><div class="site-logo"><img src="{{ asset('img/ntgreen.jpeg') }}" alt="Logo"></div></div>
                                <p>Your trusted source for quality health and pharmaceutical products.</p>
                                <div class="footer-address">
                                    <ul>
                                        <li><div class="footer-address-icon"><i class="icon-placeholder"></i></div><div class="footer-address-info"><p>Brooklyn, New York, United States</p></div></li>
                                        <li><div class="footer-address-icon"><i class="icon-call"></i></div><div class="footer-address-info"><p><a href="tel:+0123-456789">+0123-456789</a></p></div></li>
                                        <li><div class="footer-address-icon"><i class="icon-mail"></i></div><div class="footer-address-info"><p><a href="mailto:example@example.com">example@example.com</a></p></div></li>
                                    </ul>
                                </div>
                                <div class="ltn__social-media mt-20">
                                    <ul>
                                        <li><a href="#" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
                                        <li><a href="#" title="Twitter"><i class="fab fa-twitter"></i></a></li>
                                        <li><a href="#" title="Linkedin"><i class="fab fa-linkedin"></i></a></li>
                                        <li><a href="#" title="Youtube"><i class="fab fa-youtube"></i></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-2 col-md-6 col-sm-6 col-12">
                            <div class="footer-widget footer-menu-widget clearfix">
                                <h4 class="footer-title">Services</h4>
                                <div class="footer-menu"><ul>
                                    <li><a href="#">Order tracking</a></li>
                                    <li><a href="#">Wish List</a></li>
                                    <li><a href="{{ route('login') }}">Login</a></li>
                                    <li><a href="#">My account</a></li>
                                    <li><a href="#">Terms & Conditions</a></li>
                                    <li><a href="#">Promotional Offers</a></li>
                                </ul></div>
                            </div>
                        </div>
                        <div class="col-xl-2 col-md-6 col-sm-6 col-12">
                            <div class="footer-widget footer-menu-widget clearfix">
                                <h4 class="footer-title">Customer Care</h4>
                                <div class="footer-menu"><ul>
                                    <li><a href="{{ route('login') }}">Login</a></li>
                                    <li><a href="#">My account</a></li>
                                    <li><a href="#">Wish List</a></li>
                                    <li><a href="#">Order tracking</a></li>
                                    <li><a href="#">FAQ</a></li>
                                    <li><a href="#">Contact us</a></li>
                                </ul></div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6 col-sm-12 col-12">
                            <div class="footer-widget footer-newsletter-widget">
                                <h4 class="footer-title">Newsletter</h4>
                                <p>Subscribe to our weekly Newsletter and receive updates via email.</p>
                                <div class="footer-newsletter">
                                    <form action="#"><input type="email" name="email" placeholder="Email*"><div class="btn-wrapper"><button class="theme-btn-1 btn" type="submit"><i class="fas fa-location-arrow"></i></button></div></form>
                                </div>
                                <h5 class="mt-30">We Accept</h5>
                                <img src="{{ asset('img/icons/payment-4.png') }}" alt="Payment">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ltn__copyright-area ltn__copyright-2 section-bg-7 plr--5">
                <div class="container-fluid ltn__border-top-2">
                    <div class="row">
                        <div class="col-md-6 col-12">
                            <div class="ltn__copyright-design clearfix">
                                <p>All Rights Reserved @ Notrace Trip <span class="current-year">{{ date('Y') }}</span></p>
                            </div>
                        </div>
                        <div class="col-md-6 col-12 align-self-center">
                            <div class="ltn__copyright-menu text-end">
                                <ul>
                                    <li><a href="#">Terms & Conditions</a></li>
                                    <li><a href="#">Claim</a></li>
                                    <li><a href="#">Privacy & Policy</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </footer>

        <!-- QUICK VIEW MODAL -->
        <div class="ltn__modal-area ltn__quick-view-modal-area">
            <div class="modal fade" id="quick_view_modal" tabindex="-1">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                            <div class="ltn__quick-view-modal-inner">
                                <div class="modal-product-item">
                                    <div class="row">
                                        <div class="col-lg-6 col-12">
                                            <div class="modal-product-img-gallery">
                                                <div class="modal-product-img-main">
                                                    <img id="quick-view-image-main" src="{{ asset('img/product/default.png') }}" alt="Product" class="w-100">
                                                    <div class="modal-img-arrow modal-img-arrow-prev" id="modal-arrow-prev" style="display:none;"><i class="fas fa-chevron-left"></i></div>
                                                    <div class="modal-img-arrow modal-img-arrow-next" id="modal-arrow-next" style="display:none;"><i class="fas fa-chevron-right"></i></div>
                                                    <div class="modal-img-counter" id="modal-img-counter" style="display:none;"><span id="current-img-index">1</span> / <span id="total-img-count">1</span></div>
                                                </div>
                                                <div id="quick-view-thumbnails" class="modal-product-img-thumbnails" style="display:none;"></div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-12">
                                            <div class="modal-product-info">
                                                <div class="product-ratting"><ul>
                                                    <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                    <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                    <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                    <li><a href="#"><i class="fas fa-star-half-alt"></i></a></li>
                                                    <li><a href="#"><i class="far fa-star"></i></a></li>
                                                </ul></div>
                                                <h3 id="quick-view-name">Product Name</h3>
                                                <div class="product-price">
                                                    <span id="quick-view-price">$0.00</span>
                                                    <del id="quick-view-old-price" style="display:none;">$0.00</del>
                                                </div>
                                                <div class="modal-product-meta ltn__product-details-menu-1">
                                                    <ul>
                                                        <li><strong>Category:</strong> <span id="quick-view-category">-</span></li>
                                                        <li><strong>Stock:</strong> <span id="quick-view-stock">In Stock</span></li>
                                                    </ul>
                                                </div>
                                                <div class="ltn__product-details-menu-2">
                                                    <ul>
                                                        <li>
                                                            <div class="cart-plus-minus">
                                                                <input type="text" value="01" name="qtybutton" class="cart-plus-minus-box">
                                                            </div>
                                                        </li>
                                                        <li>
                                                            <a href="#" class="theme-btn-1 btn btn-effect-1" title="Add to Cart" onclick="addToCart(event)">
                                                                <i class="fas fa-shopping-cart"></i><span>ADD TO CART</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="ltn__product-details-menu-3">
                                                    <ul>
                                                        <li><a href="#" class="add-to-wishlist" title="Wishlist" onclick="addToWishlist(event)"><i class="far fa-heart"></i><span>Add to Wishlist</span></a></li>
                                                        <li><a href="#" id="quick-view-detail-link" title="View Full Details"><i class="fas fa-eye"></i><span>View Details</span></a></li>
                                                    </ul>
                                                </div>
                                                <hr>
                                                <div class="ltn__social-media"><ul>
                                                    <li>Share:</li>
                                                    <li><a href="#" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
                                                    <li><a href="#" title="Twitter"><i class="fab fa-twitter"></i></a></li>
                                                    <li><a href="#" title="Linkedin"><i class="fab fa-linkedin"></i></a></li>
                                                    <li><a href="#" title="Instagram"><i class="fab fa-instagram"></i></a></li>
                                                </ul></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- ADD TO CART MODAL -->
        <div class="ltn__modal-area ltn__add-to-cart-modal-area">
            <div class="modal fade" id="add_to_cart_modal" tabindex="-1">
                <div class="modal-dialog modal-md" role="document">
                    <div class="modal-content">
                        <div class="modal-header"><button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>
                        <div class="modal-body">
                            <div class="ltn__quick-view-modal-inner"><div class="modal-product-item"><div class="row"><div class="col-12">
                                <div class="modal-product-img"><img id="cart-modal-image" src="{{ asset('img/product/default.png') }}" alt="Product"></div>
                                <div class="modal-product-info">
                                    <h5><a href="#" id="cart-modal-name">Product Name</a></h5>
                                    <p class="added-cart"><i class="fa fa-check-circle"></i> Successfully added to your Cart</p>
                                    <div class="btn-wrapper">
                                        <a href="{{ route('cart.index') }}" class="theme-btn-1 btn btn-effect-1">View Cart</a>
                                        <a href="#" class="theme-btn-2 btn btn-effect-2">Checkout</a>
                                    </div>
                                </div>
                            </div></div></div></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- WISHLIST MODAL -->
        <div class="ltn__modal-area ltn__add-to-cart-modal-area">
            <div class="modal fade" id="liton_wishlist_modal" tabindex="-1">
                <div class="modal-dialog modal-md" role="document">
                    <div class="modal-content">
                        <div class="modal-header"><button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>
                        <div class="modal-body">
                            <div class="ltn__quick-view-modal-inner"><div class="modal-product-item"><div class="row"><div class="col-12">
                                <div class="modal-product-img"><img id="wishlist-modal-image" src="{{ asset('img/product/default.png') }}" alt="Product"></div>
                                <div class="modal-product-info">
                                    <h5><a href="#" id="wishlist-modal-name">Product Name</a></h5>
                                    <p class="added-cart"><i class="fa fa-check-circle"></i> Successfully added to your Wishlist</p>
                                    <div class="btn-wrapper"><a href="#" class="theme-btn-1 btn btn-effect-1">View Wishlist</a></div>
                                </div>
                            </div></div></div></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <div class="preloader d-none" id="preloader">
        <div class="preloader-inner"><div class="spinner"><div class="dot1"></div><div class="dot2"></div></div></div>
    </div>

    <script src="{{ asset('js/plugins.js') }}"></script>
    <script src="{{ asset('js/main.js') }}"></script>

    <script>
        const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
        let productImages = [];
        let currentImageIndex = 0;

        function updateCartHeader(cartCount, cartTotal) {
            document.querySelectorAll('.mini-cart-icon sup').forEach(el => el.textContent = cartCount);
            document.querySelectorAll('.ltn__secondary-color').forEach(el => {
                if (el.closest('.mini-cart-icon-2')) el.textContent = '$' + cartTotal;
            });
        }

        function showCartModal(productName, productImage) {
            document.getElementById('cart-modal-name').textContent = productName;
            document.getElementById('cart-modal-image').src = productImage;
            new bootstrap.Modal(document.getElementById('add_to_cart_modal')).show();
        }

        function doAddToCart(productId, quantity, productName, productImage) {
            return fetch('/cart/add', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': csrfToken, 'Accept': 'application/json' },
                body: JSON.stringify({ product_id: productId, quantity: quantity })
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) { updateCartHeader(data.cart_count, data.cart_total); showCartModal(productName, productImage); }
                else { alert(data.message || 'Failed to add to cart'); }
            })
            .catch(err => { console.error('Cart error:', err); alert('Something went wrong.'); });
        }

        function addToCart(event) {
            event.preventDefault();
            const productId    = document.getElementById('quick_view_modal').getAttribute('data-current-product-id');
            const quantity     = parseInt(document.querySelector('#quick_view_modal .cart-plus-minus-box')?.value) || 1;
            const productName  = document.getElementById('quick-view-name').textContent;
            const productImage = document.getElementById('quick-view-image-main').src;
            if (!productId) { alert('Product not found'); return; }
            const qv = bootstrap.Modal.getInstance(document.getElementById('quick_view_modal'));
            if (qv) qv.hide();
            doAddToCart(productId, quantity, productName, productImage);
        }

        function addToWishlist(event) {
            event.preventDefault();
            const productName  = document.getElementById('quick-view-name').textContent;
            const productImage = document.getElementById('quick-view-image-main').src;
            const qv = bootstrap.Modal.getInstance(document.getElementById('quick_view_modal'));
            if (qv) qv.hide();
            document.getElementById('wishlist-modal-name').textContent = productName;
            document.getElementById('wishlist-modal-image').src = productImage;
            new bootstrap.Modal(document.getElementById('liton_wishlist_modal')).show();
        }

        async function fetchProductImages(productId) {
            try {
                const images = await fetch(`/api/product/${productId}/images`).then(r => r.json());
                productImages = images; currentImageIndex = 0;
                const container = document.getElementById('quick-view-thumbnails');
                const mainImg   = document.getElementById('quick-view-image-main');
                const arrowPrev = document.getElementById('modal-arrow-prev');
                const arrowNext = document.getElementById('modal-arrow-next');
                const counter   = document.getElementById('modal-img-counter');
                container.innerHTML = '';
                if (images.length > 1) {
                    container.style.display = 'flex'; arrowPrev.style.display = 'flex'; arrowNext.style.display = 'flex'; counter.style.display = 'block';
                    document.getElementById('total-img-count').textContent = images.length;
                    updateImageCounter();
                    images.forEach((image, index) => {
                        const thumb = document.createElement('div');
                        thumb.className = 'modal-thumbnail' + (index === 0 ? ' active' : '');
                        thumb.setAttribute('data-index', index);
                        const path = image.image_path || image.image;
                        thumb.innerHTML = `<img src="/storage/${path}" alt="Image ${index + 1}">`;
                        thumb.addEventListener('click', () => showImage(parseInt(thumb.getAttribute('data-index'))));
                        container.appendChild(thumb);
                    });
                    mainImg.src = `/storage/${images[0].image_path || images[0].image}`;
                    updateArrowStates();
                } else if (images.length === 1) {
                    [container, arrowPrev, arrowNext, counter].forEach(el => el.style.display = 'none');
                    mainImg.src = `/storage/${images[0].image_path || images[0].image}`;
                } else {
                    [container, arrowPrev, arrowNext, counter].forEach(el => el.style.display = 'none');
                }
            } catch (err) {
                ['quick-view-thumbnails','modal-arrow-prev','modal-arrow-next','modal-img-counter'].forEach(id => document.getElementById(id).style.display = 'none');
            }
        }

        function showImage(index) {
            if (index < 0 || index >= productImages.length) return;
            currentImageIndex = index;
            document.getElementById('quick-view-image-main').src = `/storage/${productImages[index].image_path || productImages[index].image}`;
            document.querySelectorAll('.modal-thumbnail').forEach((t, i) => t.classList.toggle('active', i === index));
            updateArrowStates(); updateImageCounter();
        }

        function navigateImage(direction) {
            if (direction === 'prev' && currentImageIndex > 0) showImage(currentImageIndex - 1);
            else if (direction === 'next' && currentImageIndex < productImages.length - 1) showImage(currentImageIndex + 1);
        }

        function updateArrowStates() {
            document.getElementById('modal-arrow-prev').classList.toggle('disabled', currentImageIndex === 0);
            document.getElementById('modal-arrow-next').classList.toggle('disabled', currentImageIndex === productImages.length - 1);
        }

        function updateImageCounter() {
            document.getElementById('current-img-index').textContent = currentImageIndex + 1;
        }

        document.addEventListener('DOMContentLoaded', function() {

            // MOBILE MENU
            const menuToggle = document.querySelector('.ltn__utilize-toggle');
            const mobileMenu = document.querySelector('#ltn__utilize-mobile-menu');
            const overlay    = document.querySelector('.ltn__utilize-overlay');
            const closeBtn   = document.querySelector('#ltn__utilize-mobile-menu .ltn__utilize-close');
            if (menuToggle && mobileMenu) {
                menuToggle.addEventListener('click', function(e) {
                    e.preventDefault();
                    mobileMenu.classList.add('ltn__utilize-open');
                    if (overlay) overlay.classList.add('ltn__utilize-open');
                    document.body.style.overflow = 'hidden';
                });
            }
            if (closeBtn) {
                closeBtn.addEventListener('click', function() {
                    mobileMenu.classList.remove('ltn__utilize-open');
                    if (overlay) overlay.classList.remove('ltn__utilize-open');
                    document.body.style.overflow = '';
                });
            }
            if (overlay) {
                overlay.addEventListener('click', function() {
                    mobileMenu.classList.remove('ltn__utilize-open');
                    overlay.classList.remove('ltn__utilize-open');
                    document.body.style.overflow = '';
                });
            }

            // ADD TO CART FROM PRODUCT CARDS
            document.addEventListener('click', function(e) {
                const btn = e.target.closest('.add-to-cart-btn');
                if (!btn) return;
                e.preventDefault();
                const productId   = btn.getAttribute('data-product-id');
                const productCard = btn.closest('.ltn__product-item');
                if (!productId) { alert('Product ID not found.'); return; }
                const productName  = productCard?.querySelector('.product-title a')?.textContent || 'Product';
                const productImage = productCard?.querySelector('.product-img img')?.src || '';
                const originalHTML = btn.innerHTML;
                btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
                btn.style.pointerEvents = 'none';
                doAddToCart(productId, 1, productName, productImage).finally(() => {
                    btn.innerHTML = originalHTML;
                    btn.style.pointerEvents = 'auto';
                });
            });

            // QUICK VIEW MODAL
            document.querySelectorAll('[data-bs-target="#quick_view_modal"]').forEach(button => {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    const productCard = this.closest('.ltn__product-item');
                    if (!productCard) return;
                    const img      = productCard.querySelector('.product-img img');
                    const name     = productCard.querySelector('.product-title a');
                    const price    = productCard.querySelector('.product-price span');
                    const oldPrice = productCard.querySelector('.product-price del');
                    const link     = productCard.querySelector('.product-title a');
                    const pid      = productCard.getAttribute('data-product-id');
                    if (img)      document.getElementById('quick-view-image-main').src = img.src;
                    if (name)     document.getElementById('quick-view-name').textContent = name.textContent;
                    if (price)    document.getElementById('quick-view-price').textContent = price.textContent;
                    if (oldPrice) { document.getElementById('quick-view-old-price').textContent = oldPrice.textContent; document.getElementById('quick-view-old-price').style.display = 'inline'; }
                    else { document.getElementById('quick-view-old-price').style.display = 'none'; }
                    if (link) document.getElementById('quick-view-detail-link').href = link.href;
                    if (pid) { document.getElementById('quick_view_modal').setAttribute('data-current-product-id', pid); fetchProductImages(pid); }
                });
            });

            // MODAL IMAGE ARROWS
            document.getElementById('modal-arrow-prev')?.addEventListener('click', () => navigateImage('prev'));
            document.getElementById('modal-arrow-next')?.addEventListener('click', () => navigateImage('next'));
            document.addEventListener('keydown', function(e) {
                if (document.querySelector('#quick_view_modal')?.classList.contains('show')) {
                    if (e.key === 'ArrowLeft')  navigateImage('prev');
                    if (e.key === 'ArrowRight') navigateImage('next');
                }
            });

            // CART PLUS/MINUS - only for non-cart pages (quick view modal quantity)
            document.querySelectorAll('.cart-plus-minus').forEach(element => {
                const input = element.querySelector('.cart-plus-minus-box');
                if (!input || element.querySelector('.inc') || input.classList.contains('cart-qty-input')) return;
                const inc = document.createElement('button');
                inc.className = 'inc qtybutton'; inc.textContent = '+'; inc.type = 'button';
                const dec = document.createElement('button');
                dec.className = 'dec qtybutton'; dec.textContent = '-'; dec.type = 'button';
                element.appendChild(dec);
                element.appendChild(inc);
                inc.addEventListener('click', () => { input.value = (parseInt(input.value) || 1) + 1; });
                dec.addEventListener('click', () => { const v = parseInt(input.value) || 1; if (v > 1) input.value = v - 1; });
            });
        });
    </script>

    {{-- Page-specific scripts go here (ONLY ONE @stack) --}}
    @stack('scripts')

</body>
</html>
