    @extends('layouts.navigation')



    <style>
        :root {
            --primary-color: #0a9a73;
            --secondary-color: #2c3e50;
            --sidebar-bg: #1e272e;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f8f9fa;
        }

        /* Sidebar Styles */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            height: 100vh;
            width: 260px;
            background: var(--sidebar-bg);
            padding: 0;
            z-index: 1000;
        }

        .sidebar-header {
            padding: 25px 20px;
            background: rgba(10, 154, 115, 0.1);
            border-bottom: 2px solid var(--primary-color);
        }

        .sidebar-header h3 {
            color: var(--primary-color);
            font-size: 24px;
            font-weight: 700;
            margin: 0;
        }

        .sidebar-menu {
            list-style: none;
            padding: 20px 0;
            margin: 0;
        }

        .sidebar-menu li {
            margin-bottom: 5px;
        }

        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 15px 20px;
            color: #bdc3c7;
            text-decoration: none;
            transition: all 0.3s;
        }

        .sidebar-menu a:hover,
        .sidebar-menu a.active {
            background: var(--primary-color);
            color: white;
            padding-left: 30px;
        }

        .sidebar-menu a i {
            width: 25px;
            margin-right: 15px;
            font-size: 18px;
        }

        /* Main Content */
        .main-content {
            margin-left: 260px;
            padding: 0;
            min-height: 100vh;
        }

        /* Top Navigation */
        .top-nav {
            background: white;
            padding: 20px 30px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 999;
        }

        .top-nav h2 {
            color: var(--secondary-color);
            margin: 0;
            font-size: 28px;
            font-weight: 600;
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .logout-btn {
            background: rgba(231, 76, 60, 0.1);
            color: #e74c3c;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }

        .logout-btn:hover {
            background: #e74c3c;
            color: white;
        }

        /* Page Content */
        .page-content {
            padding: 30px;
        }

        /* Card Styles */
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.08);
            margin-bottom: 30px;
        }

        .card-header {
            background: var(--primary-color);
            color: white;
            border: none;
            border-radius: 12px 12px 0 0 !important;
            padding: 20px 25px;
            font-weight: 600;
            font-size: 18px;
        }

        .card-body {
            padding: 25px;
        }

        /* Form Styles */
        .form-label {
            font-weight: 600;
            color: var(--secondary-color);
            margin-bottom: 8px;
        }

        .form-control {
            border-radius: 8px;
            border: 2px solid #e9ecef;
            padding: 12px 15px;
            transition: all 0.3s;
        }

        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(10, 154, 115, 0.15);
        }

        .btn-primary {
            background: var(--primary-color);
            border: none;
            padding: 12px 30px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s;
        }

        .btn-primary:hover {
            background: #087d5d;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(10, 154, 115, 0.3);
        }

        /* Table Styles */
        .table {
            margin: 0;
        }

        .table thead th {
            background: #f8f9fa;
            color: var(--secondary-color);
            font-weight: 600;
            border: none;
            padding: 15px;
            font-size: 14px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .table tbody td {
            padding: 15px;
            vertical-align: middle;
            border-bottom: 1px solid #f1f3f5;
        }

        .table tbody tr:hover {
            background: #f8f9fa;
        }

        /* Badge Styles */
        .badge {
            padding: 8px 15px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 12px;
        }

        .badge-success {
            background: rgba(39, 174, 96, 0.1);
            color: #27ae60;
        }

        .badge-info {
            background: rgba(52, 152, 219, 0.1);
            color: #3498db;
        }

        /* Action Buttons */
        .btn-action {
            padding: 8px 15px;
            border-radius: 6px;
            font-size: 14px;
            border: none;
            cursor: pointer;
            transition: all 0.3s;
            margin-right: 5px;
        }

        .btn-edit {
            background: rgba(52, 152, 219, 0.1);
            color: #3498db;
        }

        .btn-edit:hover {
            background: #3498db;
            color: white;
        }

        .btn-delete {
            background: rgba(231, 76, 60, 0.1);
            color: #e74c3c;
        }

        .btn-delete:hover {
            background: #e74c3c;
            color: white;
        }

        /* Alert Styles */
        .alert {
            border: none;
            border-radius: 10px;
            padding: 15px 20px;
            margin-bottom: 20px;
        }

        .alert-success {
            background: rgba(39, 174, 96, 0.1);
            color: #27ae60;
            border-left: 4px solid #27ae60;
        }

        .alert-danger {
            background: rgba(231, 76, 60, 0.1);
            color: #e74c3c;
            border-left: 4px solid #e74c3c;
        }

        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #95a5a6;
        }

        .empty-state i {
            font-size: 64px;
            margin-bottom: 20px;
            opacity: 0.5;
        }

        .empty-state h4 {
            margin-bottom: 10px;
            color: #7f8c8d;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-260px);
            }

            .main-content {
                margin-left: 0;
            }

            .table {
                font-size: 14px;
            }

            .btn-action {
                padding: 6px 10px;
                font-size: 12px;
            }
        }
    </style>


    @section('content')

        <!-- Top Navigation -->
        <!-- Main Content -->
        <div class="main-content">
            <!-- Top Navigation -->
            <div class="top-nav">
                <h2>Category</h2>

                <div class="user-profile">
                    <div class="user-info">
                        <div class="user-name">{{ auth()->user()->name }}</div>
                        <div class="user-role">Administrator</div>
                    </div>
                    <img src="https://ui-avatars.com/api/?name={{ urlencode(auth()->user()->name) }}&background=0a9a73&color=fff"
                        alt="User">
                    <form method="POST" action="{{ route('logout') }}" style="margin: 0;">
                        @csrf
                        <button type="submit" class="logout-btn">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </button>
                    </form>
                </div>
            </div>

            <!-- Page Content -->
            <div class="page-content">

                <!-- Success/Error Messages -->
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle"></i> {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <div class="row">
                    <!-- Add/Edit Category Form -->
                    <div class="col-lg-4">
                        <div class="card">
                            <div class="card-header">
                                <i class="fas fa-{{ isset($category) ? 'edit' : 'plus-circle' }}"></i>
                                {{ isset($category) ? 'Edit Category' : 'Add New Category' }}
                            </div>
                            <div class="card-body">
                                @if (isset($category))
                                    <!-- Edit Form -->
                                    <form method="POST" action="{{ route('admin.categories.update', $category) }}">
                                        @csrf
                                        @method('PUT')

                                        <div class="mb-3">
                                            <label for="name" class="form-label">Category Name *</label>
                                            <input type="text" class="form-control @error('name') is-invalid @enderror"
                                                id="name" name="name" value="{{ old('name', $category->name) }}"
                                                placeholder="e.g., Weight Loss, Drugs" required>
                                            @error('name')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <small class="text-muted">The slug will be auto-generated</small>
                                        </div>

                                        <div class="d-grid gap-2">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-save"></i> Update Category
                                            </button>
                                            <a href="" class="btn btn-secondary">
                                                <i class="fas fa-times"></i> Cancel
                                            </a>
                                        </div>
                                    </form>
                                @else
                                    <!-- Add Form -->
                                    <form method="POST" action="{{ route('admin.categories.store') }}">
                                        @csrf

                                        <div class="mb-3">
                                            <label for="name" class="form-label">Category Name *</label>
                                            <input type="text" class="form-control @error('name') is-invalid @enderror"
                                                id="name" name="name" value="{{ old('name') }}"
                                                placeholder="e.g., Weight Loss, Drugs" required autofocus>
                                            @error('name')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <small class="text-muted">The slug will be auto-generated</small>
                                        </div>

                                        <div class="d-grid">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-plus-circle"></i> Add Category
                                            </button>
                                        </div>
                                    </form>
                                @endif
                            </div>
                        </div>

                        <!-- Quick Stats -->
                        <div class="card">
                            <div class="card-header">
                                <i class="fas fa-chart-bar"></i> Quick Stats
                            </div>
                            <div class="card-body">
                                <div class="d-flex justify-content-between mb-3">
                                    <span class="text-muted">Total Categories:</span>
                                    <strong class="text-primary">{{ $categories->count() }}</strong>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <span class="text-muted">Total Products:</span>
                                    <strong class="text-success">{{ $categories->sum('products_count') }}</strong>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Categories Table -->
                    <div class="col-lg-8">
                        <div class="card">
                            <div class="card-header">
                                <i class="fas fa-table"></i> All Categories ({{ $categories->count() }})
                            </div>
                            <div class="card-body p-0">
                                @if ($categories->count() > 0)
                                    <div class="table-responsive">
                                        <table class="table table-hover mb-0">
                                            <thead>
                                                <tr>
                                                    <th width="5%">#</th>
                                                    <th width="30%">Name</th>
                                                    <th width="15%" class="text-center">Products</th>
                                                    <th width="20%" class="text-center">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($categories as $index => $cat)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>
                                                            <strong>{{ $cat->name }}</strong>
                                                        </td>
                                                        <td class="text-center">
                                                            @if ($cat->products_count > 0)
                                                                <span class="badge badge-success">
                                                                    {{ $cat->products_count }}
                                                                    {{ Str::plural('Product', $cat->products_count) }}
                                                                </span>
                                                            @else
                                                                <span class="badge badge-info">0 Products</span>
                                                            @endif
                                                        </td>
                                                        <td class="text-center">
                                                            <!-- Edit Button -->
                                                            <a href="{{ route('admin.categories.edit', $cat) }}"
                                                                class="btn-action btn-edit" title="Edit">
                                                                <i class="fas fa-edit"></i>
                                                            </a>

                                                            <!-- Delete Button -->
                                                            <form action="{{ route('admin.categories.destroy', $cat) }}"
                                                                method="POST" style="display: inline;"
                                                                onsubmit="return confirm('Are you sure you want to delete this category?');">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn-action btn-delete"
                                                                    title="Delete"
                                                                    {{ $cat->products_count > 0 ? 'disabled' : '' }}>
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </form>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @else
                                    <div class="empty-state">
                                        <i class="fas fa-inbox"></i>
                                        <h4>No Categories Yet</h4>
                                        <p>Create your first category using the form on the left.</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    @endsection
