<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Admin Dashboard - Notrace Trip</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <style>
        :root {
            --primary-color: #0a9a73;
            --secondary-color: #2c3e50;
            --sidebar-bg: #1e272e;
            --sidebar-hover: #0a9a73;
            --card-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f8f9fa;
        }

        /* ── Sidebar ── */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            height: 100vh;
            width: 260px;
            background: var(--sidebar-bg);
            padding: 0;
            z-index: 1000;
            transition: transform 0.3s ease;
        }

        .sidebar-header {
            padding: 25px 20px;
            background: rgba(10, 154, 115, 0.1);
            border-bottom: 2px solid var(--primary-color);
        }

        .sidebar-header h3 {
            color: var(--primary-color);
            font-size: 24px;
            font-weight: 700;
            margin: 0;
        }

        .sidebar-header p {
            color: #95a5a6;
            font-size: 12px;
            margin: 5px 0 0 0;
        }

        .sidebar-menu {
            list-style: none;
            padding: 20px 0;
        }

        .sidebar-menu li {
            margin-bottom: 5px;
        }

        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 15px 20px;
            color: #bdc3c7;
            text-decoration: none;
            transition: all 0.3s;
            font-size: 15px;
        }

        .sidebar-menu a:hover,
        .sidebar-menu a.active {
            background: var(--sidebar-hover);
            color: white;
            padding-left: 30px;
        }

        .sidebar-menu a i {
            width: 25px;
            margin-right: 15px;
            font-size: 18px;
        }

        /* ── Main Content ── */
        .main-content {
            margin-left: 260px;
            padding: 0;
            min-height: 100vh;
            transition: margin-left 0.3s ease;
        }

        /* ── Top Nav ── */
        .top-nav {
            background: white;
            padding: 20px 30px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 999;
        }

        .top-nav h2 {
            color: var(--secondary-color);
            margin: 0;
            font-size: 28px;
            font-weight: 600;
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .user-profile img {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            border: 2px solid var(--primary-color);
        }

        .user-profile .user-info {
            text-align: right;
        }

        .user-profile .user-name {
            font-weight: 600;
            color: var(--secondary-color);
            font-size: 14px;
        }

        .user-profile .user-role {
            font-size: 12px;
            color: #7f8c8d;
        }

        /* ── Hamburger ── */
        .hamburger-btn {
            display: none;
            background: none;
            border: none;
            cursor: pointer;
            padding: 5px;
            flex-direction: column;
            gap: 5px;
        }

        .hamburger-btn span {
            display: block;
            width: 25px;
            height: 3px;
            background: var(--secondary-color);
            border-radius: 3px;
            transition: all 0.3s ease;
        }

        .hamburger-btn.open span:nth-child(1) {
            transform: translateY(8px) rotate(45deg);
        }

        .hamburger-btn.open span:nth-child(2) {
            opacity: 0;
        }

        .hamburger-btn.open span:nth-child(3) {
            transform: translateY(-8px) rotate(-45deg);
        }

        /* ── Sidebar Overlay (mobile) ── */
        .sidebar-overlay {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
        }

        .sidebar-overlay.active {
            display: block;
        }

        /* ── Dashboard ── */
        .dashboard-content {
            padding: 30px;
        }

        .stats-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 25px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: var(--card-shadow);
            position: relative;
            overflow: hidden;
            transition: transform 0.3s;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: var(--primary-color);
        }

        .stat-card.blue::before {
            background: #3498db;
        }

        .stat-card.orange::before {
            background: #e67e22;
        }

        .stat-card.purple::before {
            background: #9b59b6;
        }

        .stat-card.red::before {
            background: #e74c3c;
        }

        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .stat-title {
            color: #7f8c8d;
            font-size: 13px;
            text-transform: uppercase;
            font-weight: 600;
            letter-spacing: 0.5px;
        }

        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }

        .stat-icon.green {
            background: rgba(10, 154, 115, 0.1);
            color: #0a9a73;
        }

        .stat-icon.blue {
            background: rgba(52, 152, 219, 0.1);
            color: #3498db;
        }

        .stat-icon.orange {
            background: rgba(230, 126, 34, 0.1);
            color: #e67e22;
        }

        .stat-icon.purple {
            background: rgba(155, 89, 182, 0.1);
            color: #9b59b6;
        }

        .stat-icon.red {
            background: rgba(231, 76, 60, 0.1);
            color: #e74c3c;
        }

        .stat-value {
            font-size: 32px;
            font-weight: 700;
            color: var(--secondary-color);
            margin-bottom: 5px;
        }

        .stat-change {
            font-size: 13px;
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .stat-change.positive {
            color: #27ae60;
        }

        .stat-change.negative {
            color: #e74c3c;
        }

        /* ── Charts ── */
        .charts-row {
            display: grid;
            grid-template-columns: 2fr 1fr;
            gap: 25px;
            margin-bottom: 30px;
        }

        .chart-card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: var(--card-shadow);
        }

        .chart-header {
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid #ecf0f1;
        }

        .chart-title {
            font-size: 18px;
            font-weight: 600;
            color: var(--secondary-color);
        }

        /* ── Activity ── */
        .activity-card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: var(--card-shadow);
        }

        .activity-item {
            display: flex;
            align-items: start;
            gap: 15px;
            padding: 15px 0;
            border-bottom: 1px solid #ecf0f1;
        }

        .activity-item:last-child {
            border-bottom: none;
        }

        .activity-icon {
            width: 40px;
            height: 40px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .activity-icon.success {
            background: rgba(39, 174, 96, 0.1);
            color: #27ae60;
        }

        .activity-icon.warning {
            background: rgba(230, 126, 34, 0.1);
            color: #e67e22;
        }

        .activity-icon.info {
            background: rgba(52, 152, 219, 0.1);
            color: #3498db;
        }

        .activity-content {
            flex: 1;
        }

        .activity-title {
            font-weight: 600;
            color: var(--secondary-color);
            margin-bottom: 3px;
        }

        .activity-time {
            font-size: 12px;
            color: #95a5a6;
        }

        /* ── Quick Actions ── */
        .quick-actions {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 30px;
        }

        .action-btn {
            background: white;
            border: 2px solid #ecf0f1;
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            text-decoration: none;
            color: var(--secondary-color);
            transition: all 0.3s;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 10px;
        }

        .action-btn:hover {
            border-color: var(--primary-color);
            background: var(--primary-color);
            color: white;
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(10, 154, 115, 0.3);
        }

        .action-btn i {
            font-size: 28px;
        }

        /* ── Logout ── */
        .logout-btn {
            background: rgba(231, 76, 60, 0.1);
            color: #e74c3c;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }

        .logout-btn:hover {
            background: #e74c3c;
            color: white;
        }

        /* ── Responsive ── */
        @media (max-width: 992px) {
            .hamburger-btn {
                display: flex;
            }

            .sidebar {
                transform: translateX(-260px);
                z-index: 1001;
            }

            .sidebar.active {
                transform: translateX(0);
            }

            .main-content {
                margin-left: 0;
            }

            .charts-row {
                grid-template-columns: 1fr;
            }

            .stats-row {
                grid-template-columns: 1fr 1fr;
            }
        }

        @media (max-width: 576px) {
            .stats-row {
                grid-template-columns: 1fr;
            }

            .dashboard-content {
                padding: 15px;
            }

            .top-nav {
                padding: 15px;
            }

            .top-nav h2 {
                font-size: 20px;
            }
        }
    </style>
</head>

<body>

    <!-- Sidebar Overlay -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <h3><i class="fas fa-heartbeat"></i> Notrace Trip</h3>
            <p>Admin Dashboard</p>
        </div>
        <ul class="sidebar-menu">
            <li><a href="{{ route('admin.dashboard') }}"
                    {{ request()->routeIs('admin.dashboard') ? 'class=active' : '' }}><i class="fas fa-home"></i>
                    Dashboard</a></li>
            <li><a href="{{ route('admin.products.index') }}"
                    {{ request()->routeIs('admin.products*') ? 'class=active' : '' }}><i class="fas fa-pills"></i>
                    Products</a></li>
            <li><a href="{{ route('admin.orders') }}" {{ request()->routeIs('admin.orders*') ? 'class=active' : '' }}><i
                        class="fas fa-shopping-cart"></i> Orders</a></li>

            <li><a href="{{ route('admin.payment.index') }}"
                    {{ request()->routeIs('admin.payment*') ? 'class=active' : '' }}><i class="fas fa-wallet"></i>
                    Payment Methods</a></li>

        </ul>
    </div>

    @yield('content')

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Chart.js — only runs if canvas elements exist -->
    <script>
        const salesCanvas = document.getElementById('salesChart');
        if (salesCanvas) {
            new Chart(salesCanvas.getContext('2d'), {
                type: 'line',
                data: {
                    labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                    datasets: [{
                        label: 'Sales ($)',
                        data: [12000, 19000, 15000, 25000, 22000, 30000, 28000, 35000, 32000, 40000, 38000,
                            45000
                        ],
                        borderColor: '#0a9a73',
                        backgroundColor: 'rgba(10,154,115,0.1)',
                        tension: 0.4,
                        fill: true
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                callback: v => '$' + v.toLocaleString()
                            }
                        }
                    }
                }
            });
        }

        const categoryCanvas = document.getElementById('categoryChart');
        if (categoryCanvas) {
            new Chart(categoryCanvas.getContext('2d'), {
                type: 'doughnut',
                data: {
                    labels: ['Drugs', 'Weight Loss', 'First Aid', 'Vitamins', 'Equipment'],
                    datasets: [{
                        data: [35, 25, 20, 12, 8],
                        backgroundColor: ['#0a9a73', '#3498db', '#e67e22', '#9b59b6', '#e74c3c']
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'bottom'
                        }
                    }
                }
            });
        }

        // ── Hamburger / Sidebar Toggle ────────────────────────────────────────
        document.addEventListener('DOMContentLoaded', function() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebarOverlay');

            // Inject hamburger into every .top-nav on this layout
            document.querySelectorAll('.top-nav').forEach(nav => {
                const btn = document.createElement('button');
                btn.className = 'hamburger-btn';
                btn.id = 'hamburgerBtn';
                btn.setAttribute('aria-label', 'Toggle menu');
                btn.innerHTML = '<span></span><span></span><span></span>';
                nav.prepend(btn);

                btn.addEventListener('click', toggleSidebar);
            });

            overlay.addEventListener('click', closeSidebar);

            function toggleSidebar() {
                const btn = document.getElementById('hamburgerBtn');
                const isOpen = sidebar.classList.toggle('active');
                overlay.classList.toggle('active', isOpen);
                if (btn) btn.classList.toggle('open', isOpen);
            }

            function closeSidebar() {
                sidebar.classList.remove('active');
                overlay.classList.remove('active');
                const btn = document.getElementById('hamburgerBtn');
                if (btn) btn.classList.remove('open');
            }

            // Close sidebar on nav link click (mobile)
            document.querySelectorAll('.sidebar-menu a').forEach(link => {
                link.addEventListener('click', () => {
                    if (window.innerWidth <= 992) closeSidebar();
                });
            });
        });
    </script>

    @stack('scripts')

</body>

</html>
