@extends('layouts.app')

@section('content')
    <div class="ltn__utilize-overlay"></div>

    <!-- BREADCRUMB AREA START -->
    <div class="ltn__breadcrumb-area text-left bg-overlay-white-30 bg-image" data-bs-bg="img/bg/14.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ltn__breadcrumb-inner">
                        <h1 class="page-title">Shop</h1>
                        <div class="ltn__breadcrumb-list">
                            <ul>
                                <li><a href="{{ route('home') }}"><span class="ltn__secondary-color"><i class="fas fa-home"></i></span> Home</a></li>
                                <li>Shop</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- BREADCRUMB AREA END -->

    <!-- PRODUCT AREA START -->
    <div class="ltn__product-area ltn__product-gutter mb-120">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="ltn__shop-options">
                        <ul>
                            <li>
                                <div class="ltn__grid-list-tab-menu">
                                    <div class="nav">
                                        <a class="active show" data-bs-toggle="tab" href="#liton_product_grid"><i class="fas fa-th-large"></i></a>
                                        <a data-bs-toggle="tab" href="#liton_product_list"><i class="fas fa-list"></i></a>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="showing-product-number text-right">
                                    <span>Showing {{ $products->firstItem() ?? 0 }}–{{ $products->lastItem() ?? 0 }} of {{ $products->total() }} results</span>
                                </div>
                            </li>
                            <li>
                                <div class="short-by text-center">
                                    <form action="{{ route('shop') }}" method="GET" id="sortForm">
                                        @if(request('search'))
                                            <input type="hidden" name="search" value="{{ request('search') }}">
                                        @endif
                                        @if(request('category'))
                                            <input type="hidden" name="category" value="{{ request('category') }}">
                                        @endif
                                        <select class="nice-select" name="sort" onchange="document.getElementById('sortForm').submit()">
                                            <option value="latest"     {{ request('sort') == 'latest'     ? 'selected' : '' }}>Latest Products</option>
                                            <option value="price_low"  {{ request('sort') == 'price_low'  ? 'selected' : '' }}>Price: Low to High</option>
                                            <option value="price_high" {{ request('sort') == 'price_high' ? 'selected' : '' }}>Price: High to Low</option>
                                            <option value="name"       {{ request('sort') == 'name'       ? 'selected' : '' }}>Name: A-Z</option>
                                        </select>
                                    </form>
                                </div>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <!-- GRID VIEW -->
                        <div class="tab-pane fade active show" id="liton_product_grid">
                            <div class="ltn__product-tab-content-inner ltn__product-grid-view">
                                <div class="row">
                                    @forelse($products as $product)
                                        <div class="col-xl-4 col-sm-6 col-6">
                                            <div class="ltn__product-item ltn__product-item-3 text-center" data-product-id="{{ $product->id }}">
                                                <div class="product-img">
                                                    <a href="{{ route('product.show', $product->slug) }}">
                                                        @if($product->images->count() > 0)
                                                            <img src="{{ asset('storage/' . ($product->images->first()->image_path ?? $product->images->first()->image)) }}" alt="{{ $product->name }}">
                                                        @else
                                                            <img src="{{ asset('img/product/default.png') }}" alt="{{ $product->name }}">
                                                        @endif
                                                    </a>
                                                    @if($product->is_on_sale)
                                                        <div class="product-badge">
                                                            <ul>
                                                                <li class="sale-badge bg-red">
                                                                    -{{ round((($product->price - $product->discount_price) / $product->price) * 100) }}%
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="product-info">
                                                    <div class="product-ratting">
                                                        <ul>
                                                            <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                            <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                            <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                            <li><a href="#"><i class="fas fa-star-half-alt"></i></a></li>
                                                            <li><a href="#"><i class="far fa-star"></i></a></li>
                                                        </ul>
                                                    </div>
                                                    <h2 class="product-title">
                                                        <a href="{{ route('product.show', $product->slug) }}">{{ $product->name }}</a>
                                                    </h2>
                                                    <div class="product-price">
                                                        @if($product->is_on_sale)
                                                            <span>${{ number_format($product->discount_price, 2) }}</span>
                                                            <del>${{ number_format($product->price, 2) }}</del>
                                                        @else
                                                            <span>${{ number_format($product->price, 2) }}</span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @empty
                                        <div class="col-12 text-center py-5">
                                            <i class="fas fa-search fa-3x mb-3" style="color:#ddd;"></i>
                                            <p class="text-muted">
                                                @if(request('search'))
                                                    No products found for "<strong>{{ request('search') }}</strong>".
                                                @else
                                                    No products found.
                                                @endif
                                            </p>
                                            <a href="{{ route('shop') }}" class="theme-btn-1 btn btn-effect-1 mt-3">Browse All Products</a>
                                        </div>
                                    @endforelse
                                </div>
                            </div>
                        </div>

                        <!-- LIST VIEW -->
                        <div class="tab-pane fade" id="liton_product_list">
                            <div class="ltn__product-tab-content-inner ltn__product-list-view">
                                <div class="row">
                                    @forelse($products as $product)
                                        <div class="col-lg-12">
                                            <div class="ltn__product-item ltn__product-item-3" data-product-id="{{ $product->id }}">
                                                <div class="product-img">
                                                    <a href="{{ route('product.show', $product->slug) }}">
                                                        @if($product->images->count() > 0)
                                                            <img src="{{ asset('storage/' . ($product->images->first()->image_path ?? $product->images->first()->image)) }}" alt="{{ $product->name }}">
                                                        @else
                                                            <img src="{{ asset('img/product/default.png') }}" alt="{{ $product->name }}">
                                                        @endif
                                                    </a>
                                                    @if($product->is_on_sale)
                                                        <div class="product-badge">
                                                            <ul>
                                                                <li class="sale-badge bg-red">
                                                                    -{{ round((($product->price - $product->discount_price) / $product->price) * 100) }}%
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="product-info">
                                                    <h2 class="product-title">
                                                        <a href="{{ route('product.show', $product->slug) }}">{{ $product->name }}</a>
                                                    </h2>
                                                    <div class="product-ratting">
                                                        <ul>
                                                            <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                            <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                            <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                            <li><a href="#"><i class="fas fa-star-half-alt"></i></a></li>
                                                            <li><a href="#"><i class="far fa-star"></i></a></li>
                                                        </ul>
                                                    </div>
                                                    <div class="product-price">
                                                        @if($product->is_on_sale)
                                                            <span>${{ number_format($product->discount_price, 2) }}</span>
                                                            <del>${{ number_format($product->price, 2) }}</del>
                                                        @else
                                                            <span>${{ number_format($product->price, 2) }}</span>
                                                        @endif
                                                    </div>
                                                    <div class="product-brief">
                                                        <p>{{ Str::limit($product->description, 150) }}</p>
                                                    </div>
                                                    <div class="product-hover-action">
                                                        <ul>
                                                            <li>
                                                                <a href="#" title="Quick View" data-bs-toggle="modal" data-bs-target="#quick_view_modal">
                                                                    <i class="far fa-eye"></i>
                                                                </a>
                                                            </li>
                                                            <li>
                                                                <a href="#" title="Add to Cart" class="add-to-cart-btn" data-product-id="{{ $product->id }}">
                                                                    <i class="fas fa-shopping-cart"></i>
                                                                </a>
                                                            </li>
                                                            <li>
                                                                <a href="#" title="Wishlist" class="add-to-wishlist-btn">
                                                                    <i class="far fa-heart"></i>
                                                                </a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @empty
                                        <div class="col-12 text-center py-5">
                                            <i class="fas fa-search fa-3x mb-3" style="color:#ddd;"></i>
                                            <p class="text-muted">
                                                @if(request('search'))
                                                    No products found for "<strong>{{ request('search') }}</strong>".
                                                @else
                                                    No products found.
                                                @endif
                                            </p>
                                            <a href="{{ route('shop') }}" class="theme-btn-1 btn btn-effect-1 mt-3">Browse All Products</a>
                                        </div>
                                    @endforelse
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- PAGINATION -->
                    @if($products->hasPages())
                        <div class="ltn__pagination-area text-center">
                            <div class="ltn__pagination">
                                {{ $products->withQueryString()->links() }}
                            </div>
                        </div>
                    @endif
                </div>

                <!-- SIDEBAR -->
                <div class="col-lg-4">
                    <aside class="sidebar ltn__shop-sidebar ltn__right-sidebar">

                        <!-- Category Widget -->
                        <div class="widget ltn__menu-widget">
                            <h4 class="ltn__widget-title ltn__widget-title-border">Product Categories</h4>
                            <ul>
                                <li class="{{ !request('category') ? 'active' : '' }}">
                                    <a href="{{ route('shop') }}">
                                        All Products
                                        <span><i class="fas fa-long-arrow-alt-right"></i></span>
                                    </a>
                                </li>
                                @foreach($categories as $cat)
                                    <li class="{{ isset($category) && $category->id == $cat->id ? 'active' : '' }}">
                                        <a href="{{ route('shop.category', $cat->slug) }}">
                                            {{ $cat->name }}
                                            <span>({{ $cat->products_count }})</span>
                                            <span><i class="fas fa-long-arrow-alt-right"></i></span>
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>

                        <!-- Top Rated Products Widget -->
                        <div class="widget ltn__top-rated-product-widget">
                            <h4 class="ltn__widget-title ltn__widget-title-border">Top Rated Product</h4>
                            <ul>
                                @foreach($topRatedProducts as $topProduct)
                                    <li>
                                        <div class="top-rated-product-item clearfix">
                                            <div class="top-rated-product-img">
                                                <a href="{{ route('product.show', $topProduct->slug) }}">
                                                    {{-- ✅ Fixed: was incorrectly using $product instead of $topProduct --}}
                                                    @if($topProduct->images->count() > 0)
                                                        <img src="{{ asset('storage/' . ($topProduct->images->first()->image_path ?? $topProduct->images->first()->image)) }}"
                                                            alt="{{ $topProduct->name }}">
                                                    @else
                                                        <img src="{{ asset('img/product/default.png') }}"
                                                            alt="{{ $topProduct->name }}">
                                                    @endif
                                                </a>
                                            </div>
                                            <div class="top-rated-product-info">
                                                <div class="product-ratting">
                                                    <ul>
                                                        <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                        <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                        <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                        <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                        <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                    </ul>
                                                </div>
                                                <h6>
                                                    <a href="{{ route('product.show', $topProduct->slug) }}">{{ Str::limit($topProduct->name, 30) }}</a>
                                                </h6>
                                                <div class="product-price">
                                                    @if($topProduct->is_on_sale)
                                                        <span>${{ number_format($topProduct->discount_price, 2) }}</span>
                                                        <del>${{ number_format($topProduct->price, 2) }}</del>
                                                    @else
                                                        <span>${{ number_format($topProduct->price, 2) }}</span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>

                        <!-- Search Widget -->
                        <div class="widget ltn__search-widget">
                            <h4 class="ltn__widget-title ltn__widget-title-border">Search Products</h4>
                            <form action="{{ route('shop') }}" method="GET">
                                <input type="text" name="search" placeholder="Search products..." value="{{ request('search') }}">
                                <button type="submit"><i class="fas fa-search"></i></button>
                            </form>
                        </div>

                    </aside>
                </div>
            </div>
        </div>
    </div>
    <!-- PRODUCT AREA END -->
@endsection
