@extends('layouts.app')

@section('content')

    <div class="ltn__breadcrumb-area text-left bg-overlay-white-30 bg-image" data-bs-bg="{{ asset('img/bg/14.jpg') }}">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ltn__breadcrumb-inner">
                        <h1 class="page-title">My Orders</h1>
                        <div class="ltn__breadcrumb-list">
                            <ul>
                                <li><a href="{{ route('home') }}"><span class="ltn__secondary-color"><i
                                                class="fas fa-home"></i></span> Home</a></li>
                                <li>My Orders</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="litn__wishlist-area pb-70 pt-60">
        <div class="container">

            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show mb-4">
                    <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <!-- Filter Tabs -->
            <div class="mb-4">
                <ul class="nav order-tabs" id="orderTabs">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#all-orders">
                            All Orders <span class="tab-count">{{ $orders->total() }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#pending-orders">
                            Pending <span class="tab-count">{{ $pendingCount }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#active-orders">
                            In Progress <span class="tab-count">{{ $activeCount }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#completed-orders">
                            Completed <span class="tab-count">{{ $completedCount }}</span>
                        </a>
                    </li>
                </ul>
            </div>

            @if ($orders->isEmpty())
                <div class="text-center py-5">
                    <i class="fas fa-box-open" style="font-size:64px; color:#ddd;"></i>
                    <h4 class="mt-3" style="color:#999;">No orders yet</h4>
                    <p class="text-muted">You haven't placed any orders yet.</p>
                    <a href="{{ route('shop') }}" class="theme-btn-1 btn btn-effect-1 mt-3">
                        <i class="fas fa-shopping-bag me-2"></i> Start Shopping
                    </a>
                </div>
            @else
                {{-- ═══════════════════════════════════════════
             ORDER CARD MACRO (inline, no partials)
        ═══════════════════════════════════════════ --}}
                @php
                    $orderCard = function ($order) {
                        return $order;
                    };
                @endphp

                <div class="tab-content">

                    {{-- ALL ORDERS --}}
                    <div class="tab-pane fade show active" id="all-orders">
                        @foreach ($orders as $order)
                            <div class="order-card">
                                <div class="order-card-header">
                                    <div class="d-flex align-items-center gap-3 flex-wrap">
                                        <span class="order-id"><i class="fas fa-hashtag me-1"
                                                style="color:#0a9a73;"></i>Order #{{ $order->id }}</span>
                                        <span class="order-date"><i
                                                class="far fa-calendar-alt me-1"></i>{{ $order->created_at->format('M d, Y') }}</span>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                        <span class="status-badge status-{{ $order->status }}">
                                            @switch($order->status)
                                                @case('pending')
                                                    <i class="fas fa-clock me-1"></i> Pending Payment
                                                @break

                                                @case('payment_submitted')
                                                    <i class="fas fa-search me-1"></i> Payment Under Review
                                                @break

                                                @case('processing')
                                                    <i class="fas fa-cogs me-1"></i> Processing
                                                @break

                                                @case('shipped')
                                                    <i class="fas fa-shipping-fast me-1"></i> Shipped
                                                @break

                                                @case('completed')
                                                    <i class="fas fa-check-circle me-1"></i> Completed
                                                @break

                                                @case('cancelled')
                                                    <i class="fas fa-times-circle me-1"></i> Cancelled
                                                @break

                                                @default
                                                    {{ ucfirst($order->status) }}
                                            @endswitch
                                        </span>
                                        <span class="text-muted" style="font-size:12px;">
                                            {{ $order->payment_method === 'crypto' ? 'Crypto' : 'Gift Card' }}
                                        </span>
                                    </div>
                                </div>
                                <div class="order-card-body">
                                    <div class="row">
                                        <div class="col-md-7">
                                            <div class="order-items-preview mb-3">
                                                @foreach ($order->items->take(4) as $item)
                                                    @if ($item->product && $item->product->images->count() > 0)
                                                        <img src="{{ asset('storage/' . $item->product->images->first()->image) }}"
                                                            alt="{{ $item->product_name }}" class="order-item-img"
                                                            title="{{ $item->product_name }} × {{ $item->quantity }}">
                                                    @else
                                                        <div class="order-item-placeholder"
                                                            title="{{ $item->product_name }}">
                                                            <i class="fas fa-pills"></i>
                                                        </div>
                                                    @endif
                                                @endforeach
                                                @if ($order->items->count() > 4)
                                                    <div class="order-more-badge">+{{ $order->items->count() - 4 }}</div>
                                                @endif
                                            </div>
                                            <div style="font-size:13px; color:#555; line-height:1.8;">
                                                @foreach ($order->items as $item)
                                                    <span>{{ $item->product_name }} <span
                                                            class="text-muted">×{{ $item->quantity }}</span></span>
                                                    @if (!$loop->last)
                                                        <span class="mx-1" style="color:#ddd;">|</span>
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="col-md-5 text-md-end mt-3 mt-md-0">
                                            <div style="font-size:13px; color:#666; margin-bottom:6px;">
                                                <i class="fas fa-map-marker-alt me-1 text-muted"></i>
                                                {{ $order->city }}, {{ $order->country }}
                                            </div>
                                            <div style="font-size:12px; color:#999; margin-bottom:6px;">
                                                <i class="fas fa-truck me-1"></i>
                                                {{ $order->shipping_type === 'shipping_discrete' ? 'Discrete Shipping' : 'Non-Discrete Shipping' }}
                                            </div>
                                            @if ($order->latestTracking && $order->latestTracking->estimated_delivery)
                                                <div style="font-size:12px; color:#0a9a73; font-weight:600;">
                                                    <i class="fas fa-calendar-check me-1"></i>
                                                    Est. Delivery:
                                                    {{ \Carbon\Carbon::parse($order->latestTracking->estimated_delivery)->format('M d, Y') }}
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="order-card-footer">
                                    <div class="order-total">Total: <span>${{ number_format($order->total, 2) }}</span>
                                    </div>
                                    <div class="d-flex gap-2 flex-wrap">
                                        @if ($order->status === 'pending')
                                            <a href="{{ route('payment.page', $order->id) }}" class="btn-pay-now">
                                                <i class="fas fa-credit-card me-1"></i> Complete Payment
                                            </a>
                                        @endif
                                        @if (!in_array($order->status, ['pending', 'cancelled']))
                                            <button class="btn-track" onclick="trackOrder({{ $order->id }})">
                                                <i class="fas fa-map-marker-alt me-1"></i> Track Order
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        <div class="mt-4">{{ $orders->links() }}</div>
                    </div>

                    {{-- PENDING --}}
                    <div class="tab-pane fade" id="pending-orders">
                        @php $pendingOrders = $orders->filter(fn($o) => in_array($o->status, ['pending','payment_submitted'])); @endphp
                        @forelse($pendingOrders as $order)
                            <div class="order-card">
                                <div class="order-card-header">
                                    <div class="d-flex align-items-center gap-3 flex-wrap">
                                        <span class="order-id"><i class="fas fa-hashtag me-1"
                                                style="color:#0a9a73;"></i>Order #{{ $order->id }}</span>
                                        <span class="order-date"><i
                                                class="far fa-calendar-alt me-1"></i>{{ $order->created_at->format('M d, Y') }}</span>
                                    </div>
                                    <span class="status-badge status-{{ $order->status }}">
                                        @switch($order->status)
                                            @case('pending')
                                                <i class="fas fa-clock me-1"></i> Pending Payment
                                            @break

                                            @case('payment_submitted')
                                                <i class="fas fa-search me-1"></i> Payment Under Review
                                            @break

                                            @default
                                                {{ ucfirst($order->status) }}
                                        @endswitch
                                    </span>
                                </div>
                                <div class="order-card-body">
                                    <div class="order-items-preview mb-3">
                                        @foreach ($order->items->take(4) as $item)
                                            @if ($item->product && $item->product->images->count() > 0)
                                                <img src="{{ asset('storage/' . $item->product->images->first()->image) }}"
                                                    alt="{{ $item->product_name }}" class="order-item-img">
                                            @else
                                                <div class="order-item-placeholder"><i class="fas fa-pills"></i></div>
                                            @endif
                                        @endforeach
                                        @if ($order->items->count() > 4)
                                            <div class="order-more-badge">+{{ $order->items->count() - 4 }}</div>
                                        @endif
                                    </div>
                                    <div style="font-size:13px; color:#555;">
                                        @foreach ($order->items as $item)
                                            <span>{{ $item->product_name }} <span
                                                    class="text-muted">×{{ $item->quantity }}</span></span>
                                            @if (!$loop->last)
                                                <span class="mx-1" style="color:#ddd;">|</span>
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                                <div class="order-card-footer">
                                    <div class="order-total">Total: <span>${{ number_format($order->total, 2) }}</span>
                                    </div>
                                    @if ($order->status === 'pending')
                                        <a href="{{ route('payment.page', $order->id) }}" class="btn-pay-now">
                                            <i class="fas fa-credit-card me-1"></i> Complete Payment
                                        </a>
                                    @endif
                                </div>
                            </div>
                            @empty
                                <div class="text-center py-4 text-muted"><i
                                        class="fas fa-check-circle me-2 text-success"></i>No pending orders.</div>
                            @endforelse
                        </div>

                        {{-- IN PROGRESS --}}
                        <div class="tab-pane fade" id="active-orders">
                            @php $activeOrders = $orders->filter(fn($o) => in_array($o->status, ['processing','shipped'])); @endphp
                            @forelse($activeOrders as $order)
                                <div class="order-card">
                                    <div class="order-card-header">
                                        <div class="d-flex align-items-center gap-3 flex-wrap">
                                            <span class="order-id"><i class="fas fa-hashtag me-1"
                                                    style="color:#0a9a73;"></i>Order #{{ $order->id }}</span>
                                            <span class="order-date"><i
                                                    class="far fa-calendar-alt me-1"></i>{{ $order->created_at->format('M d, Y') }}</span>
                                        </div>
                                        <span class="status-badge status-{{ $order->status }}">
                                            @switch($order->status)
                                                @case('processing')
                                                    <i class="fas fa-cogs me-1"></i> Processing
                                                @break

                                                @case('shipped')
                                                    <i class="fas fa-shipping-fast me-1"></i> Shipped
                                                @break

                                                @default
                                                    {{ ucfirst($order->status) }}
                                            @endswitch
                                        </span>
                                    </div>
                                    <div class="order-card-body">
                                        <div class="row">
                                            <div class="col-md-7">
                                                <div class="order-items-preview mb-3">
                                                    @foreach ($order->items->take(4) as $item)
                                                        @if ($item->product && $item->product->images->count() > 0)
                                                            <img src="{{ asset('storage/' . $item->product->images->first()->image) }}"
                                                                alt="{{ $item->product_name }}" class="order-item-img">
                                                        @else
                                                            <div class="order-item-placeholder"><i class="fas fa-pills"></i>
                                                            </div>
                                                        @endif
                                                    @endforeach
                                                    @if ($order->items->count() > 4)
                                                        <div class="order-more-badge">+{{ $order->items->count() - 4 }}</div>
                                                    @endif
                                                </div>
                                                <div style="font-size:13px; color:#555;">
                                                    @foreach ($order->items as $item)
                                                        <span>{{ $item->product_name }} <span
                                                                class="text-muted">×{{ $item->quantity }}</span></span>
                                                        @if (!$loop->last)
                                                            <span class="mx-1" style="color:#ddd;">|</span>
                                                        @endif
                                                    @endforeach
                                                </div>
                                            </div>
                                            <div class="col-md-5 text-md-end mt-3 mt-md-0">
                                                @if ($order->latestTracking && $order->latestTracking->estimated_delivery)
                                                    <div style="font-size:12px; color:#0a9a73; font-weight:600;">
                                                        <i class="fas fa-calendar-check me-1"></i>
                                                        Est. Delivery:
                                                        {{ \Carbon\Carbon::parse($order->latestTracking->estimated_delivery)->format('M d, Y') }}
                                                    </div>
                                                @endif
                                                @if ($order->latestTracking && $order->latestTracking->location)
                                                    <div style="font-size:12px; color:#856404; margin-top:4px;">
                                                        <i
                                                            class="fas fa-map-marker-alt me-1"></i>{{ $order->latestTracking->location }}
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="order-card-footer">
                                        <div class="order-total">Total: <span>${{ number_format($order->total, 2) }}</span>
                                        </div>
                                        <button class="btn-track" onclick="trackOrder({{ $order->id }})">
                                            <i class="fas fa-map-marker-alt me-1"></i> Track Order
                                        </button>
                                    </div>
                                </div>
                                @empty
                                    <div class="text-center py-4 text-muted"><i class="fas fa-info-circle me-2"></i>No orders in
                                        progress.</div>
                                @endforelse
                            </div>

                            {{-- COMPLETED --}}
                            <div class="tab-pane fade" id="completed-orders">
                                @php $completedOrders = $orders->filter(fn($o) => in_array($o->status, ['completed','cancelled'])); @endphp
                                @forelse($completedOrders as $order)
                                    <div class="order-card">
                                        <div class="order-card-header">
                                            <div class="d-flex align-items-center gap-3 flex-wrap">
                                                <span class="order-id"><i class="fas fa-hashtag me-1"
                                                        style="color:#0a9a73;"></i>Order #{{ $order->id }}</span>
                                                <span class="order-date"><i
                                                        class="far fa-calendar-alt me-1"></i>{{ $order->created_at->format('M d, Y') }}</span>
                                            </div>
                                            <span class="status-badge status-{{ $order->status }}">
                                                @switch($order->status)
                                                    @case('completed')
                                                        <i class="fas fa-check-circle me-1"></i> Completed
                                                    @break

                                                    @case('cancelled')
                                                        <i class="fas fa-times-circle me-1"></i> Cancelled
                                                    @break

                                                    @default
                                                        {{ ucfirst($order->status) }}
                                                @endswitch
                                            </span>
                                        </div>
                                        <div class="order-card-body">
                                            <div class="order-items-preview mb-3">
                                                @foreach ($order->items->take(4) as $item)
                                                    @if ($item->product && $item->product->images->count() > 0)
                                                        <img src="{{ asset('storage/' . $item->product->images->first()->image) }}"
                                                            alt="{{ $item->product_name }}" class="order-item-img">
                                                    @else
                                                        <div class="order-item-placeholder"><i class="fas fa-pills"></i></div>
                                                    @endif
                                                @endforeach
                                                @if ($order->items->count() > 4)
                                                    <div class="order-more-badge">+{{ $order->items->count() - 4 }}</div>
                                                @endif
                                            </div>
                                            <div style="font-size:13px; color:#555;">
                                                @foreach ($order->items as $item)
                                                    <span>{{ $item->product_name }} <span
                                                            class="text-muted">×{{ $item->quantity }}</span></span>
                                                    @if (!$loop->last)
                                                        <span class="mx-1" style="color:#ddd;">|</span>
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="order-card-footer">
                                            <div class="order-total">Total: <span>${{ number_format($order->total, 2) }}</span>
                                            </div>
                                            @if ($order->status === 'completed')
                                                <button class="btn-track" onclick="trackOrder({{ $order->id }})">
                                                    <i class="fas fa-history me-1"></i> View History
                                                </button>
                                            @endif
                                        </div>
                                    </div>
                                    @empty
                                        <div class="text-center py-4 text-muted"><i class="fas fa-inbox me-2"></i>No completed orders
                                            yet.</div>
                                    @endforelse
                                </div>

                            </div>
                        @endif
                    </div>
                </div>

                <!-- ═══════════════════════════════════════════════
                     ORDER TRACKING MODAL
                ═══════════════════════════════════════════════ -->
                <div class="modal fade" id="trackingModal" tabindex="-1">
                    <div class="modal-dialog modal-lg modal-dialog-centered">
                        <div class="modal-content" style="border-radius:16px; overflow:hidden; border:none;">
                            <div class="modal-header" style="background:#1a1a2e; border:none; padding:20px 25px;">
                                <div>
                                    <h5 class="modal-title text-white mb-0">
                                        <i class="fas fa-map-marker-alt me-2" style="color:#0a9a73;"></i> Order Tracking
                                    </h5>
                                    <small id="tracking-order-number" style="color:#95a5a6;"></small>
                                </div>
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                            </div>
                            <div class="modal-body p-4" id="tracking-modal-body">
                                <div class="text-center py-4">
                                    <i class="fas fa-spinner fa-spin fa-2x" style="color:#0a9a73;"></i>
                                    <p class="mt-2 text-muted">Loading tracking info...</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <style>
                    /* ── Tabs ───────────────────────────────────────────────────── */
                    .order-tabs {
                        border-bottom: 2px solid #e8e8e8;
                        gap: 5px;
                        flex-wrap: wrap;
                    }

                    .order-tabs .nav-link {
                        color: #666;
                        border: none;
                        border-radius: 0;
                        padding: 12px 20px;
                        font-weight: 600;
                        font-size: 14px;
                        border-bottom: 3px solid transparent;
                        transition: all 0.2s;
                    }

                    .order-tabs .nav-link:hover {
                        color: #0a9a73;
                    }

                    .order-tabs .nav-link.active {
                        color: #0a9a73;
                        border-bottom-color: #0a9a73;
                        background: none;
                    }

                    .tab-count {
                        background: #f0f0f0;
                        color: #666;
                        border-radius: 20px;
                        padding: 2px 8px;
                        font-size: 12px;
                        margin-left: 6px;
                    }

                    .order-tabs .nav-link.active .tab-count {
                        background: rgba(10, 154, 115, 0.15);
                        color: #0a9a73;
                    }

                    /* ── Order Card ─────────────────────────────────────────────── */
                    .order-card {
                        background: #fff;
                        border-radius: 12px;
                        margin-bottom: 20px;
                        box-shadow: 0 2px 15px rgba(0, 0, 0, 0.06);
                        overflow: hidden;
                        border: 1px solid #f0f0f0;
                        transition: box-shadow 0.2s;
                    }

                    .order-card:hover {
                        box-shadow: 0 4px 25px rgba(0, 0, 0, 0.1);
                    }

                    .order-card-header {
                        display: flex;
                        align-items: center;
                        justify-content: space-between;
                        padding: 16px 22px;
                        background: #f9f9f9;
                        border-bottom: 1px solid #f0f0f0;
                        flex-wrap: wrap;
                        gap: 10px;
                    }

                    .order-id {
                        font-weight: 700;
                        color: #1a1a2e;
                        font-size: 15px;
                    }

                    .order-date {
                        color: #999;
                        font-size: 13px;
                    }

                    .order-card-body {
                        padding: 20px 22px;
                    }

                    .order-card-footer {
                        padding: 14px 22px;
                        border-top: 1px solid #f0f0f0;
                        display: flex;
                        align-items: center;
                        justify-content: space-between;
                        flex-wrap: wrap;
                        gap: 10px;
                        background: #fafafa;
                    }

                    .order-total {
                        font-weight: 700;
                        color: #1a1a2e;
                        font-size: 16px;
                    }

                    .order-total span {
                        color: #0a9a73;
                        font-size: 18px;
                    }

                    /* ── Item Images ────────────────────────────────────────────── */
                    .order-items-preview {
                        display: flex;
                        gap: 10px;
                        align-items: center;
                        flex-wrap: wrap;
                    }

                    .order-item-img {
                        width: 60px;
                        height: 60px;
                        border-radius: 8px;
                        object-fit: cover;
                        border: 1px solid #eee;
                    }

                    .order-item-placeholder {
                        width: 60px;
                        height: 60px;
                        border-radius: 8px;
                        background: #f0f0f0;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        color: #ccc;
                        font-size: 20px;
                    }

                    .order-more-badge {
                        width: 60px;
                        height: 60px;
                        border-radius: 8px;
                        background: #f0faf7;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        color: #0a9a73;
                        font-weight: 700;
                        font-size: 13px;
                        border: 2px dashed #0a9a73;
                    }

                    /* ── Status Badges ──────────────────────────────────────────── */
                    .status-badge {
                        padding: 5px 14px;
                        border-radius: 20px;
                        font-size: 12px;
                        font-weight: 700;
                    }

                    .status-pending {
                        background: #fff3cd;
                        color: #856404;
                    }

                    .status-payment_submitted {
                        background: #cce5ff;
                        color: #004085;
                    }

                    .status-processing {
                        background: #d4edda;
                        color: #155724;
                    }

                    .status-shipped {
                        background: #d1ecf1;
                        color: #0c5460;
                    }

                    .status-completed {
                        background: #d4edda;
                        color: #155724;
                    }

                    .status-cancelled {
                        background: #f8d7da;
                        color: #721c24;
                    }

                    /* ── Buttons ────────────────────────────────────────────────── */
                    .btn-track {
                        background: #1a1a2e;
                        color: #fff;
                        border: none;
                        padding: 8px 18px;
                        border-radius: 8px;
                        font-size: 13px;
                        font-weight: 600;
                        cursor: pointer;
                        transition: background 0.2s;
                    }

                    .btn-track:hover {
                        background: #0a9a73;
                    }

                    .btn-pay-now {
                        background: #0a9a73;
                        color: #fff;
                        border: none;
                        padding: 8px 18px;
                        border-radius: 8px;
                        font-size: 13px;
                        font-weight: 600;
                        text-decoration: none;
                        display: inline-block;
                        transition: background 0.2s;
                    }

                    .btn-pay-now:hover {
                        background: #088a67;
                        color: #fff;
                    }

                    /* ── Tracking Timeline ──────────────────────────────────────── */
                    .tracking-timeline {
                        position: relative;
                        padding-left: 32px;
                    }

                    .tracking-timeline::before {
                        content: '';
                        position: absolute;
                        left: 11px;
                        top: 0;
                        bottom: 0;
                        width: 2px;
                        background: #e8e8e8;
                    }

                    .timeline-step {
                        position: relative;
                        padding-bottom: 28px;
                    }

                    .timeline-step:last-child {
                        padding-bottom: 0;
                    }

                    .timeline-dot {
                        position: absolute;
                        left: -27px;
                        top: 3px;
                        width: 16px;
                        height: 16px;
                        border-radius: 50%;
                        background: #e8e8e8;
                        border: 3px solid #fff;
                        box-shadow: 0 0 0 2px #e8e8e8;
                        z-index: 1;
                    }

                    .timeline-dot.completed {
                        background: #0a9a73;
                        box-shadow: 0 0 0 3px rgba(10, 154, 115, 0.2);
                    }

                    .timeline-dot.current {
                        background: #fff;
                        border-color: #0a9a73;
                        box-shadow: 0 0 0 3px rgba(10, 154, 115, 0.3);
                        animation: tpulse 1.5s infinite;
                    }

                    @keyframes tpulse {

                        0%,
                        100% {
                            box-shadow: 0 0 0 3px rgba(10, 154, 115, 0.3);
                        }

                        50% {
                            box-shadow: 0 0 0 6px rgba(10, 154, 115, 0.1);
                        }
                    }

                    .timeline-title {
                        font-weight: 700;
                        color: #1a1a2e;
                        font-size: 14px;
                    }

                    .timeline-title.dimmed {
                        color: #bbb;
                        font-weight: 500;
                    }

                    .timeline-time {
                        font-size: 12px;
                        color: #999;
                        margin-top: 2px;
                    }

                    .timeline-note {
                        background: #f0faf7;
                        border-left: 3px solid #0a9a73;
                        padding: 7px 12px;
                        border-radius: 0 6px 6px 0;
                        font-size: 13px;
                        color: #444;
                        margin-top: 6px;
                    }

                    .timeline-location {
                        display: inline-flex;
                        align-items: center;
                        gap: 5px;
                        background: #fff3cd;
                        color: #856404;
                        padding: 3px 10px;
                        border-radius: 20px;
                        font-size: 12px;
                        font-weight: 600;
                        margin-top: 4px;
                    }

                    .est-delivery-box {
                        background: linear-gradient(135deg, #0a9a73, #088a67);
                        color: #fff;
                        border-radius: 10px;
                        padding: 16px 20px;
                        margin-bottom: 20px;
                        display: flex;
                        align-items: center;
                        gap: 15px;
                    }

                    .est-delivery-box .label {
                        font-size: 12px;
                        opacity: .85;
                    }

                    .est-delivery-box .date {
                        font-size: 20px;
                        font-weight: 700;
                    }
                </style>

                @push('scripts')
                    <script>
                        function trackOrder(orderId) {
                            document.getElementById('tracking-order-number').textContent = 'Order #' + orderId;
                            document.getElementById('tracking-modal-body').innerHTML =
                                '<div class="text-center py-4"><i class="fas fa-spinner fa-spin fa-2x" style="color:#0a9a73;"></i><p class="mt-2 text-muted">Loading...</p></div>';

                            new bootstrap.Modal(document.getElementById('trackingModal')).show();

                            fetch(`/orders/${orderId}/tracking`)
                                .then(r => r.json())
                                .then(renderTracking)
                                .catch(() => {
                                    document.getElementById('tracking-modal-body').innerHTML =
                                        '<div class="alert alert-danger"><i class="fas fa-exclamation-circle me-2"></i>Failed to load tracking info.</div>';
                                });
                        }

                        function renderTracking(data) {
                            const steps = [{
                                    key: 'pending',
                                    label: 'Order Placed',
                                    icon: 'fa-shopping-bag'
                                },
                                {
                                    key: 'payment_submitted',
                                    label: 'Payment Submitted',
                                    icon: 'fa-credit-card'
                                },
                                {
                                    key: 'processing',
                                    label: 'Processing',
                                    icon: 'fa-cogs'
                                },
                                {
                                    key: 'shipped',
                                    label: 'Shipped / In Transit',
                                    icon: 'fa-shipping-fast'
                                },
                                {
                                    key: 'completed',
                                    label: 'Delivered',
                                    icon: 'fa-check-circle'
                                },
                            ];
                            const statusOrder = ['pending', 'payment_submitted', 'processing', 'shipped', 'completed'];
                            const currentIdx = statusOrder.indexOf(data.status);

                            let html = '';

                            if (data.estimated_delivery) {
                                html += `<div class="est-delivery-box">
            <i class="fas fa-truck fa-2x"></i>
            <div>
                <div class="label">Estimated Delivery</div>
                <div class="date">${data.estimated_delivery}</div>
            </div>
        </div>`;
                            }

                            html += '<div class="tracking-timeline">';

                            if (data.status === 'cancelled') {
                                html += buildStep({
                                    dot: 'completed',
                                    dimmed: false,
                                    icon: 'fa-times-circle',
                                    iconColor: '#e74c3c',
                                    label: 'Order Cancelled',
                                    time: '',
                                    location: '',
                                    note: ''
                                });
                            } else {
                                steps.forEach((step, idx) => {
                                    let dot = '';
                                    let dimmed = true;
                                    if (idx < currentIdx) {
                                        dot = 'completed';
                                        dimmed = false;
                                    }
                                    if (idx === currentIdx) {
                                        dot = 'current';
                                        dimmed = false;
                                    }
                                    const upd = data.updates ? data.updates.find(u => u.status === step.key) : null;
                                    html += buildStep({
                                        dot,
                                        dimmed,
                                        icon: step.icon,
                                        iconColor: idx <= currentIdx ? '#0a9a73' : '#ccc',
                                        label: step.label,
                                        time: upd ? upd.created_at : '',
                                        location: upd ? upd.location : '',
                                        note: upd ? upd.note : '',
                                    });
                                });
                            }

                            html += '</div>';
                            document.getElementById('tracking-modal-body').innerHTML = html;
                        }

                        function buildStep({
                            dot,
                            dimmed,
                            icon,
                            iconColor,
                            label,
                            time,
                            location,
                            note
                        }) {
                            return `<div class="timeline-step">
        <div class="timeline-dot ${dot}"></div>
        <div class="ms-1">
            <div class="d-flex align-items-center gap-2">
                <i class="fas ${icon}" style="color:${iconColor}; width:18px; font-size:14px;"></i>
                <span class="timeline-title${dimmed ? ' dimmed' : ''}">${label}</span>
            </div>
            ${time     ? `<div class="timeline-time"><i class="far fa-clock me-1"></i>${time}</div>` : ''}
            ${location ? `<div class="timeline-location"><i class="fas fa-map-marker-alt me-1"></i>${location}</div>` : ''}
            ${note     ? `<div class="timeline-note"><i class="fas fa-comment-alt me-2" style="color:#0a9a73;"></i>${note}</div>` : ''}
        </div>
    </div>`;
                        }
                    </script>
                @endpush

            @endsection
