<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\CategoriesController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\PaymentMethodController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\ShopController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| PUBLIC ROUTES
|--------------------------------------------------------------------------
*/
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/shop', [ShopController::class, 'index'])->name('shop');
Route::get('/shop/category/{slug}', [ShopController::class, 'category'])->name('shop.category');
Route::get('/product/{slug}', [ProductController::class, 'show'])->name('product.show');
Route::get('/api/product/{id}/images', [ProductController::class, 'getImages']);
Route::get('/userType', [RoleController::class, 'index'])->name('userType');

/*
|--------------------------------------------------------------------------
| CART ROUTES (Guests + Auth)
|--------------------------------------------------------------------------
*/
Route::get('/cart', [CartController::class, 'index'])->name('cart.index');
Route::post('/cart/add', [CartController::class, 'add'])->name('cart.add');
Route::post('/cart/update', [CartController::class, 'update'])->name('cart.update');
Route::post('/cart/remove', [CartController::class, 'remove'])->name('cart.remove');

/*
|--------------------------------------------------------------------------
| GUEST ROUTES
|--------------------------------------------------------------------------
*/
Route::middleware('guest')->group(function () {
    Route::get('register', [RegisteredUserController::class, 'create'])->name('register');
    Route::get('register/seweenieopad', [RegisteredUserController::class, 'create'])->name('admin.register');
});

/*
|--------------------------------------------------------------------------
| AUTHENTICATED USER ROUTES
|--------------------------------------------------------------------------
*/
Route::middleware('auth')->group(function () {
    // Profile
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Checkout
    Route::get('/checkout', [CheckoutController::class, 'index'])->name('checkout');
    Route::post('/checkout/place', [CheckoutController::class, 'place'])->name('checkout.place');

    // Payment
    Route::get('/payment/{order}', [CheckoutController::class, 'paymentPage'])->name('payment.page');
    Route::post('/payment/{order}/confirm', [CheckoutController::class, 'confirmPayment'])->name('payment.confirm');

    // Orders
    Route::get('/orders', [OrderController::class, 'index'])->name('orders.index');
    Route::get('/orders/{order}/tracking', [OrderController::class, 'tracking'])->name('orders.tracking');
});

/*
|--------------------------------------------------------------------------
| ADMIN ROUTES
|--------------------------------------------------------------------------
*/
Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {

    Route::get('/dashboard', [AdminController::class, 'index'])->name('dashboard');

    // Categories
    Route::get('/categories', [CategoriesController::class, 'category'])->name('categories.index');
    Route::post('/categories/store', [CategoriesController::class, 'store'])->name('categories.store');
    Route::post('/categories/edit', [CategoriesController::class, 'edit'])->name('categories.edit');
    Route::put('/categories/update', [CategoriesController::class, 'update'])->name('categories.update');
    Route::delete('/categories/destroy', [CategoriesController::class, 'destroy'])->name('categories.destroy');

    // Products
    Route::get('/products', [ProductController::class, 'product'])->name('products.index');
    Route::post('/products/store', [ProductController::class, 'store'])->name('products.store');
    Route::post('/products/edit', [ProductController::class, 'edit'])->name('products.edit');
    Route::delete('/products/images/{image}', [ProductController::class, 'deleteImage'])->name('products.images.delete');
    Route::resource('products', ProductController::class)->except(['index', 'store', 'edit']);

    // Payment Methods (Crypto Wallets)
    Route::get('/payment-methods', [PaymentMethodController::class, 'index'])->name('payment.index');
    Route::post('/payment-methods/crypto/store', [PaymentMethodController::class, 'cryptoStore'])->name('payment.crypto.store');
    Route::put('/payment-methods/crypto/update', [PaymentMethodController::class, 'cryptoUpdate'])->name('payment.crypto.update');
    Route::delete('/payment-methods/crypto/{id}', [PaymentMethodController::class, 'cryptoDestroy'])->name('payment.crypto.destroy');

    // Orders
    Route::get('/orders', [OrderController::class, 'adminIndex'])->name('orders');
    Route::get('/orders/{order}', [OrderController::class, 'adminShow'])->name('orders.show');
    Route::put('/orders/{order}/tracking', [OrderController::class, 'adminUpdateTracking'])->name('orders.tracking.update');
});

require __DIR__ . '/auth.php';
