<?php $__env->startSection('content'); ?>

<div class="ltn__breadcrumb-area text-left bg-overlay-white-30 bg-image" data-bs-bg="<?php echo e(asset('img/bg/14.jpg')); ?>">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="ltn__breadcrumb-inner">
                    <h1 class="page-title">Reset Password</h1>
                    <div class="ltn__breadcrumb-list">
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><span class="ltn__secondary-color"><i class="fas fa-home"></i></span> Home</a></li>
                            <li>Reset Password</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="ltn__login-area pb-80 pt-60">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-5 col-md-7 col-sm-10">
                <div style="background:#fff; padding:40px; border-radius:12px; box-shadow:0 0 30px rgba(0,0,0,0.08);">

                    <div class="text-center mb-4">
                        <div style="width:65px;height:65px;background:rgba(10,154,115,0.1);border-radius:50%;display:flex;align-items:center;justify-content:center;margin:0 auto 15px;">
                            <i class="fas fa-key" style="font-size:26px;color:#0a9a73;"></i>
                        </div>
                        <h4 class="mb-1" style="font-weight:700;color:#2c3e50;">Set New Password</h4>
                        <p class="text-muted" style="font-size:14px;line-height:1.6;">
                            Choose a strong new password for your account.
                        </p>
                    </div>

                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger mb-4" style="border-radius:8px;font-size:14px;">
                            <ul class="mb-0 ps-3">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('password.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="token" value="<?php echo e($request->route('token')); ?>">

                        <!-- Email -->
                        <div class="input-item mb-4">
                            <label for="email" style="font-weight:600;font-size:14px;color:#2c3e50;margin-bottom:6px;display:block;">
                                <i class="fas fa-envelope me-1" style="color:#0a9a73;"></i> Email Address
                            </label>
                            <input
                                id="email"
                                type="email"
                                name="email"
                                value="<?php echo e(old('email', $request->email)); ?>"
                                required
                                autofocus
                                autocomplete="username"
                                placeholder="Your email address"
                                class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                style="height:50px;border-radius:8px;border:1px solid #ddd;padding:0 16px;font-size:14px;"
                            >
                        </div>

                        <!-- New Password -->
                        <div class="input-item mb-4">
                            <label for="password" style="font-weight:600;font-size:14px;color:#2c3e50;margin-bottom:6px;display:block;">
                                <i class="fas fa-lock me-1" style="color:#0a9a73;"></i> New Password
                            </label>
                            <div style="position:relative;">
                                <input
                                    id="password"
                                    type="password"
                                    name="password"
                                    required
                                    autocomplete="new-password"
                                    placeholder="Enter new password"
                                    class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    style="height:50px;border-radius:8px;border:1px solid #ddd;padding:0 45px 0 16px;font-size:14px;"
                                >
                                <i class="fas fa-eye toggle-password" data-target="password"
                                   style="position:absolute;right:15px;top:50%;transform:translateY(-50%);color:#999;cursor:pointer;"></i>
                            </div>
                        </div>

                        <!-- Confirm Password -->
                        <div class="input-item mb-4">
                            <label for="password_confirmation" style="font-weight:600;font-size:14px;color:#2c3e50;margin-bottom:6px;display:block;">
                                <i class="fas fa-lock me-1" style="color:#0a9a73;"></i> Confirm New Password
                            </label>
                            <div style="position:relative;">
                                <input
                                    id="password_confirmation"
                                    type="password"
                                    name="password_confirmation"
                                    required
                                    autocomplete="new-password"
                                    placeholder="Confirm new password"
                                    class="form-control <?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    style="height:50px;border-radius:8px;border:1px solid #ddd;padding:0 45px 0 16px;font-size:14px;"
                                >
                                <i class="fas fa-eye toggle-password" data-target="password_confirmation"
                                   style="position:absolute;right:15px;top:50%;transform:translateY(-50%);color:#999;cursor:pointer;"></i>
                            </div>
                        </div>

                        <button
                            type="submit"
                            class="btn w-100 fw-bold"
                            style="background:#0a9a73;color:#fff;height:50px;border-radius:8px;font-size:15px;transition:all 0.3s;"
                            onmouseover="this.style.background='#088a65'"
                            onmouseout="this.style.background='#0a9a73'"
                        >
                            <i class="fas fa-save me-2"></i> Reset Password
                        </button>

                    </form>

                    <div class="text-center mt-4" style="font-size:14px;">
                        <a href="<?php echo e(route('login')); ?>" style="color:#0a9a73;text-decoration:none;font-weight:600;">
                            <i class="fas fa-arrow-left me-1"></i> Back to Login
                        </a>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.querySelectorAll('.toggle-password').forEach(function(icon) {
    icon.addEventListener('click', function() {
        const input = document.getElementById(this.dataset.target);
        const isPassword = input.type === 'password';
        input.type = isPassword ? 'text' : 'password';
        this.classList.toggle('fa-eye', !isPassword);
        this.classList.toggle('fa-eye-slash', isPassword);
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/ozil/notrace/resources/views/auth/reset-password.blade.php ENDPATH**/ ?>