<?php $__env->startSection('content'); ?>

    <div class="ltn__breadcrumb-area text-left bg-overlay-white-30 bg-image" data-bs-bg="<?php echo e(asset('img/bg/14.jpg')); ?>">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ltn__breadcrumb-inner">
                        <h1 class="page-title">Complete Payment</h1>
                        <div class="ltn__breadcrumb-list">
                            <ul>
                                <li><a href="<?php echo e(route('home')); ?>"><span class="ltn__secondary-color"><i
                                                class="fas fa-home"></i></span> Home</a></li>
                                <li><a href="<?php echo e(route('cart.index')); ?>">Cart</a></li>
                                <li><a href="<?php echo e(route('checkout')); ?>">Checkout</a></li>
                                <li>Payment</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="ltn__checkout-area mb-120 mt-60">
        <div class="container">

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show mb-4">
                    <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show mb-4">
                    <i class="fas fa-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show mb-4">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <strong>Please fix the following errors:</strong>
                    <ul class="mb-0 mt-1">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row justify-content-center">

                <!-- ORDER SUMMARY SIDEBAR -->
                <div class="col-lg-4 mb-4">
                    <div class="card border-0 shadow-sm sticky-top" style="border-radius:12px; overflow:hidden; top:20px;">
                        <div class="card-header py-3" style="background:#1a1a2e;">
                            <h5 class="mb-0 text-white"><i class="fas fa-receipt me-2"></i> Order Summary</h5>
                        </div>
                        <div class="card-body p-0">
                            <table class="table mb-0">
                                <?php if($errors->any()): ?>
                                    <div class="alert alert-danger mb-4">
                                        <ul style="margin: 0; padding-left: 20px;">
                                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>
                                <tbody>
                                    <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="ps-3">
                                                <?php echo e($item->product_name); ?>

                                                <span class="text-muted">× <?php echo e($item->quantity); ?></span>
                                            </td>
                                            <td class="text-end pe-3">$<?php echo e(number_format($item->subtotal, 2)); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="border-top">
                                        <td class="ps-3 text-muted">Subtotal</td>
                                        <td class="text-end pe-3">$<?php echo e(number_format($order->subtotal, 2)); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="ps-3 text-muted">
                                            Shipping
                                            <small class="d-block" style="font-size:11px;">
                                                <?php echo e($order->shipping_type === 'shipping_discrete' ? 'Discrete' : 'Non-Discrete'); ?>

                                            </small>
                                        </td>
                                        <td class="text-end pe-3">$<?php echo e(number_format($order->shipping_cost, 2)); ?></td>
                                    </tr>
                                    <tr class="border-top" style="background:#f8fff8;">
                                        <td class="ps-3"><strong>Total</strong></td>
                                        <td class="text-end pe-3">
                                            <strong style="color:#0a9a73; font-size:18px;">
                                                $<?php echo e(number_format($order->total, 2)); ?>

                                            </strong>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="card-footer bg-light p-3">
                            <small class="text-muted">
                                <i class="fas fa-lock me-1"></i> Order #<?php echo e($order->id); ?> —
                                <?php echo e($order->created_at->format('M d, Y')); ?>

                            </small>
                        </div>
                    </div>
                </div>

                <!-- PAYMENT SECTION -->
                <div class="col-lg-7">

                    <?php if($order->payment_method === 'crypto'): ?>
                        <!-- ══════════════════════════════════════
                         CRYPTO PAYMENT
                    ══════════════════════════════════════ -->
                        <div class="card border-0 shadow-sm" style="border-radius:12px; overflow:hidden;">
                            <div class="card-header py-3" style="background:#1a1a2e;">
                                <h5 class="mb-0 text-white">
                                    <i class="fab fa-bitcoin me-2" style="color:#f7931a;"></i> Crypto Payment
                                </h5>
                            </div>
                            <div class="card-body p-4">

                                <div class="alert alert-warning d-flex align-items-start gap-3 mb-4">
                                    <i class="fas fa-exclamation-triangle fa-lg mt-1 flex-shrink-0"></i>
                                    <div>
                                        <strong>Important:</strong> Send exactly
                                        <strong
                                            style="color:#1a1a2e; font-size:16px;">$<?php echo e(number_format($order->total, 2)); ?></strong>
                                        worth of your selected cryptocurrency. After sending, upload your payment screenshot
                                        below.
                                    </div>
                                </div>

                                <?php if($cryptoWallets->isEmpty()): ?>
                                    <div class="alert alert-danger">
                                        <i class="fas fa-exclamation-circle me-2"></i>
                                        No crypto wallets are currently available. Please contact support.
                                    </div>
                                <?php else: ?>
                                    <form action="<?php echo e(route('payment.confirm', $order->id)); ?>" method="POST"
                                        enctype="multipart/form-data" id="crypto-form">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="wallet_id" id="selected-wallet-id">

                                        <!-- STEP 1: Select Cryptocurrency -->
                                        <div class="step-section mb-4">
                                            <h6 class="fw-bold mb-3">
                                                <span class="step-badge">1</span> Select Cryptocurrency
                                            </h6>
                                            <div class="row g-3" id="crypto-selector">
                                                <?php $__currentLoopData = $cryptoWallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-md-6">
                                                        <div class="crypto-option" data-wallet-id="<?php echo e($wallet->id); ?>"
                                                            data-address="<?php echo e($wallet->address); ?>"
                                                            data-currency="<?php echo e($wallet->currency); ?>"
                                                            data-network="<?php echo e($wallet->network); ?>">
                                                            <div class="d-flex align-items-center gap-2">
                                                                <span class="crypto-badge"
                                                                    style="background:<?php echo e($wallet->badge_color ?? '#f7931a'); ?>20; color:<?php echo e($wallet->badge_color ?? '#f7931a'); ?>;">
                                                                    <?php echo e($wallet->currency); ?>

                                                                </span>
                                                                <div>
                                                                    <div class="fw-semibold" style="font-size:14px;">
                                                                        <?php echo e($wallet->currency); ?></div>
                                                                    <small
                                                                        class="text-muted"><?php echo e($wallet->network); ?></small>
                                                                </div>
                                                            </div>
                                                            <div class="crypto-check"><i class="fas fa-check-circle"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                            <div id="crypto-select-error" class="text-danger mt-2"
                                                style="display:none; font-size:13px;">
                                                <i class="fas fa-exclamation-circle me-1"></i> Please select a
                                                cryptocurrency.
                                            </div>
                                        </div>

                                        <!-- STEP 2: Wallet Address -->
                                        <div id="wallet-address-section" class="step-section mb-4" style="display:none;">
                                            <h6 class="fw-bold mb-3">
                                                <span class="step-badge">2</span> Send Payment To This Address
                                            </h6>
                                            <div class="wallet-address-box p-3 mb-2">
                                                <div class="d-flex align-items-center justify-content-between gap-2">
                                                    <code id="selected-wallet-address"
                                                        style="font-size:13px; word-break:break-all; color:#1a1a2e; flex:1;"></code>
                                                    <button type="button"
                                                        class="btn btn-sm btn-outline-secondary flex-shrink-0"
                                                        id="copy-wallet-btn" title="Copy address">
                                                        <i class="far fa-copy"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="alert alert-danger py-2 px-3 mb-0" style="font-size:13px;">
                                                <i class="fas fa-exclamation-circle me-1"></i>
                                                Only send <span id="selected-currency-label" class="fw-bold"></span> on
                                                the
                                                <span id="selected-network-label" class="fw-bold"></span> network. Sending
                                                the wrong coin will result in permanent loss.
                                            </div>
                                        </div>

                                        <!-- STEP 3: Upload Screenshot -->
                                        <div class="step-section mb-4">
                                            <h6 class="fw-bold mb-3">
                                                <span class="step-badge">3</span> Upload Payment Screenshot
                                            </h6>
                                            <div class="upload-area" id="upload-area">
                                                <input type="file" name="payment_screenshot" id="screenshot-input"
                                                    accept="image/*" style="display:none;">
                                                <div class="text-center py-4 px-3" id="upload-placeholder"
                                                    onclick="document.getElementById('screenshot-input').click()"
                                                    style="cursor:pointer;">
                                                    <i class="fas fa-cloud-upload-alt fa-3x mb-2" style="color:#ccc;"></i>
                                                    <p class="text-muted mb-1 fw-semibold">Click to upload screenshot</p>
                                                    <small class="text-muted">PNG, JPG, GIF up to 5MB</small>
                                                </div>
                                                <div id="upload-preview"
                                                    style="display:none; text-align:center; padding:20px;">
                                                    <img id="preview-img" src=""
                                                        style="max-height:220px; border-radius:8px; border:2px solid #0a9a73; box-shadow:0 4px 12px rgba(0,0,0,0.1);">
                                                    <p class="mt-2 mb-1 text-success fw-semibold">
                                                        <i class="fas fa-check-circle me-1"></i>
                                                        <span id="preview-filename"></span>
                                                    </p>
                                                    <button type="button" class="btn btn-sm btn-outline-danger"
                                                        onclick="clearCryptoPreview()">
                                                        <i class="fas fa-times me-1"></i> Remove
                                                    </button>
                                                </div>
                                            </div>
                                            <div id="screenshot-error" class="text-danger mt-2"
                                                style="display:none; font-size:13px;">
                                                <i class="fas fa-exclamation-circle me-1"></i> Please upload a payment
                                                screenshot.
                                            </div>
                                        </div>

                                        <!-- STEP 4: Transaction ID (optional) -->
                                        <div class="step-section mb-4">
                                            <h6 class="fw-bold mb-3">
                                                <span class="step-badge">4</span> Transaction ID / Hash
                                                <span class="text-muted fw-normal" style="font-size:13px;">(optional but
                                                    recommended)</span>
                                            </h6>
                                            <input type="text" name="transaction_id"
                                                class="form-control font-monospace"
                                                placeholder="e.g. 0x4a3b2c1d9f8e7a6b5c4d3e2f1a0b9c8d7e6f5a4b"
                                                value="<?php echo e(old('transaction_id')); ?>">
                                            <small class="text-muted mt-1 d-block">
                                                <i class="fas fa-bolt me-1 text-warning"></i> Providing the transaction
                                                hash speeds up verification significantly.
                                            </small>
                                        </div>

                                        <button type="submit" class="theme-btn-1 btn btn-effect-1 w-100 py-3"
                                            id="confirm-crypto-btn">
                                            <i class="fas fa-paper-plane me-2"></i> Submit Payment Proof
                                        </button>

                                        <p class="text-center text-muted mt-3 mb-0" style="font-size:12px;">
                                            <i class="fas fa-shield-alt me-1 text-success"></i>
                                            Your payment proof is encrypted and reviewed by our team within 1–24 hours.
                                        </p>
                                    </form>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php elseif($order->payment_method === 'gift_card'): ?>
                        <!-- ══════════════════════════════════════
                         GIFT CARD PAYMENT
                    ══════════════════════════════════════ -->
                        <div class="card border-0 shadow-sm" style="border-radius:12px; overflow:hidden;">
                            <div class="card-header py-3" style="background:#1a1a2e;">
                                <h5 class="mb-0 text-white">
                                    <i class="fas fa-gift me-2" style="color:#0a9a73;"></i> Gift Card Payment
                                </h5>
                            </div>
                            <div class="card-body p-4">

                                <div class="alert alert-info d-flex align-items-start gap-3 mb-4">
                                    <i class="fas fa-info-circle fa-lg mt-1 flex-shrink-0"></i>
                                    <div>
                                        Provide gift card(s) worth a total of
                                        <strong
                                            style="font-size:16px; color:#1a1a2e;">$<?php echo e(number_format($order->total, 2)); ?></strong>.
                                        Enter the card details below and upload a clear photo showing the code.
                                    </div>
                                </div>

                                <form action="<?php echo e(route('payment.confirm', $order->id)); ?>" method="POST"
                                    enctype="multipart/form-data" id="gift-card-form">
                                    <?php echo csrf_field(); ?>

                                    <!-- Card Brand -->
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">
                                            Gift Card Brand <span class="text-danger">*</span>
                                        </label>
                                        <input type="text" name="gift_card_brand"
                                            class="form-control <?php $__errorArgs = ['gift_card_brand'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="e.g. Amazon, iTunes, Google Play, Steam, eBay"
                                            value="<?php echo e(old('gift_card_brand')); ?>" required>
                                        <?php $__errorArgs = ['gift_card_brand'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <!-- Card Code & PIN -->
                                    <div class="row">
                                        <div class="col-md-7">
                                            <div class="mb-3">
                                                <label class="form-label fw-bold">
                                                    Card Code / Claim Code <span class="text-danger">*</span>
                                                </label>
                                                <input type="text" name="gift_card_code"
                                                    class="form-control font-monospace <?php $__errorArgs = ['gift_card_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    placeholder="e.g. XXXX-XXXX-XXXX-XXXX"
                                                    value="<?php echo e(old('gift_card_code')); ?>" required>
                                                <?php $__errorArgs = ['gift_card_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                <small class="text-muted">Enter the redemption code exactly as shown on the
                                                    card.</small>
                                            </div>
                                        </div>
                                        <div class="col-md-5">
                                            <div class="mb-3">
                                                <label class="form-label fw-bold">
                                                    PIN / Security Code
                                                    <span class="text-muted fw-normal" style="font-size:12px;">(if
                                                        applicable)</span>
                                                </label>
                                                <input type="text" name="gift_card_pin"
                                                    class="form-control font-monospace <?php $__errorArgs = ['gift_card_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    placeholder="e.g. 1234 or 12345678"
                                                    value="<?php echo e(old('gift_card_pin')); ?>">
                                                <?php $__errorArgs = ['gift_card_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                <small class="text-muted">Found on the back of physical cards.</small>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Card Value -->
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">
                                            Card Value <span class="text-danger">*</span>
                                        </label>
                                        <div class="input-group">
                                            <span class="input-group-text fw-bold">$</span>
                                            <input type="number" name="gift_card_value"
                                                class="form-control <?php $__errorArgs = ['gift_card_value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="0.00" step="0.01" min="1"
                                                value="<?php echo e(old('gift_card_value')); ?>" id="gift-card-value-input" required>
                                            <?php $__errorArgs = ['gift_card_value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div id="value-check" class="mt-2" style="display:none; font-size:13px;"></div>
                                    </div>

                                    <!-- Card Photo Upload -->
                                    <div class="mb-4">
                                        <label class="form-label fw-bold">
                                            Upload Card Photo <span class="text-danger">*</span>
                                        </label>
                                        <div class="upload-area" id="gift-upload-area">
                                            <input type="file" name="gift_card_photo" id="gift-photo-input"
                                                accept="image/*" style="display:none;" required>
                                            <div class="text-center py-4 px-3" id="gift-upload-placeholder"
                                                onclick="document.getElementById('gift-photo-input').click()"
                                                style="cursor:pointer;">
                                                <i class="fas fa-camera fa-3x mb-2" style="color:#ccc;"></i>
                                                <p class="text-muted mb-1 fw-semibold">Click to upload card photo</p>
                                                <small class="text-muted">Show the card code &amp; PIN clearly — PNG, JPG
                                                    up to 5MB</small>
                                            </div>
                                            <div id="gift-upload-preview"
                                                style="display:none; text-align:center; padding:20px;">
                                                <img id="gift-preview-img" src=""
                                                    style="max-height:220px; border-radius:8px; border:2px solid #0a9a73; box-shadow:0 4px 12px rgba(0,0,0,0.1);">
                                                <p class="mt-2 mb-1 text-success fw-semibold">
                                                    <i class="fas fa-check-circle me-1"></i>
                                                    <span id="gift-preview-filename"></span>
                                                </p>
                                                <button type="button" class="btn btn-sm btn-outline-danger"
                                                    onclick="clearGiftPreview()">
                                                    <i class="fas fa-times me-1"></i> Remove
                                                </button>
                                            </div>
                                        </div>
                                        <?php $__errorArgs = ['gift_card_photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger mt-1" style="font-size:13px;"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="text-muted mt-1 d-block">
                                            <i class="fas fa-shield-alt me-1 text-success"></i>
                                            Make sure the code, PIN, and card brand are clearly visible in the photo.
                                        </small>
                                    </div>

                                    <!-- Additional Notes -->
                                    <div class="mb-4">
                                        <label class="form-label fw-bold">Additional Notes <span
                                                class="text-muted fw-normal">(optional)</span></label>
                                        <textarea name="gift_card_notes" class="form-control" rows="2"
                                            placeholder="Any additional information about the card or payment..."><?php echo e(old('gift_card_notes')); ?></textarea>
                                    </div>

                                    <button type="submit" class="theme-btn-1 btn btn-effect-1 w-100 py-3">
                                        <i class="fas fa-paper-plane me-2"></i> Submit Gift Card Details
                                    </button>

                                    <p class="text-center text-muted mt-3 mb-0" style="font-size:12px;">
                                        <i class="fas fa-shield-alt me-1 text-success"></i>
                                        Your card details are encrypted and reviewed by our team within 1–24 hours.
                                    </p>
                                </form>

                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>

    <style>
        .step-badge {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 28px;
            height: 28px;
            background: #1a1a2e;
            color: #fff;
            border-radius: 50%;
            font-size: 13px;
            font-weight: 700;
            margin-right: 8px;
            flex-shrink: 0;
        }

        .step-section {
            padding: 20px;
            background: #f9f9f9;
            border-radius: 10px;
            border: 1px solid #eee;
        }

        .crypto-option {
            border: 2px solid #e1e1e1;
            border-radius: 10px;
            padding: 14px 16px;
            cursor: pointer;
            transition: all 0.2s ease;
            background: #fff;
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: relative;
        }

        .crypto-option:hover {
            border-color: #0a9a73;
            background: #f0faf7;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(10, 154, 115, 0.1);
        }

        .crypto-option.selected {
            border-color: #0a9a73;
            background: #f0faf7;
            box-shadow: 0 0 0 3px rgba(10, 154, 115, 0.15);
        }

        .crypto-badge {
            padding: 4px 12px;
            border-radius: 20px;
            font-weight: 700;
            font-size: 13px;
        }

        .crypto-check {
            color: #0a9a73;
            font-size: 18px;
            opacity: 0;
            transition: opacity 0.2s ease;
        }

        .crypto-option.selected .crypto-check {
            opacity: 1;
        }

        .wallet-address-box {
            background: #f4f4f4;
            border-radius: 8px;
            border: 2px dashed #ccc;
            transition: border-color 0.2s;
        }

        .wallet-address-box:hover {
            border-color: #0a9a73;
        }

        .upload-area {
            border: 2px dashed #ddd;
            border-radius: 10px;
            transition: border-color 0.2s ease, background 0.2s ease;
            background: #fafafa;
            min-height: 120px;
        }

        .upload-area:hover {
            border-color: #0a9a73;
            background: #f0faf7;
        }
    </style>

    <?php $__env->startPush('scripts'); ?>
        <script>
            document.addEventListener('DOMContentLoaded', function() {

                const orderTotal = <?php echo e($order->total); ?>;

                // ── Crypto: Wallet Selection ─────────────────────────────────────────────
                document.querySelectorAll('.crypto-option').forEach(option => {
                    option.addEventListener('click', function() {
                        document.querySelectorAll('.crypto-option').forEach(o => o.classList.remove(
                            'selected'));
                        this.classList.add('selected');

                        const address = this.dataset.address;
                        const currency = this.dataset.currency;
                        const network = this.dataset.network;
                        const walletId = this.dataset.walletId;

                        document.getElementById('wallet-address-section').style.display = 'block';
                        document.getElementById('selected-wallet-address').textContent = address;
                        document.getElementById('selected-currency-label').textContent = currency;
                        document.getElementById('selected-network-label').textContent = network;
                        document.getElementById('selected-wallet-id').value = walletId;
                        document.getElementById('crypto-select-error').style.display = 'none';

                        document.getElementById('wallet-address-section').scrollIntoView({
                            behavior: 'smooth',
                            block: 'nearest'
                        });
                    });
                });

                // ── Crypto: Copy Address ─────────────────────────────────────────────────
                const copyBtn = document.getElementById('copy-wallet-btn');
                if (copyBtn) {
                    copyBtn.addEventListener('click', function() {
                        const address = document.getElementById('selected-wallet-address').textContent;
                        navigator.clipboard.writeText(address).then(() => {
                            this.innerHTML = '<i class="fas fa-check text-success"></i> Copied!';
                            setTimeout(() => {
                                this.innerHTML = '<i class="far fa-copy"></i>';
                            }, 2000);
                        }).catch(() => {
                            // Fallback for older browsers
                            const el = document.createElement('textarea');
                            el.value = address;
                            document.body.appendChild(el);
                            el.select();
                            document.execCommand('copy');
                            document.body.removeChild(el);
                            this.innerHTML = '<i class="fas fa-check text-success"></i> Copied!';
                            setTimeout(() => {
                                this.innerHTML = '<i class="far fa-copy"></i>';
                            }, 2000);
                        });
                    });
                }

                // ── Crypto: Screenshot Preview ───────────────────────────────────────────
                const screenshotInput = document.getElementById('screenshot-input');
                if (screenshotInput) {
                    screenshotInput.addEventListener('change', function() {
                        if (this.files && this.files[0]) {
                            const file = this.files[0];
                            if (file.size > 5 * 1024 * 1024) {
                                alert('File size exceeds 5MB. Please choose a smaller image.');
                                this.value = '';
                                return;
                            }
                            const reader = new FileReader();
                            reader.onload = e => {
                                document.getElementById('preview-img').src = e.target.result;
                                document.getElementById('preview-filename').textContent = file.name;
                                document.getElementById('upload-placeholder').style.display = 'none';
                                document.getElementById('upload-preview').style.display = 'block';
                                document.getElementById('screenshot-error').style.display = 'none';
                            };
                            reader.readAsDataURL(file);
                        }
                    });
                }

                // ── Crypto: Form Validation ──────────────────────────────────────────────
                const cryptoForm = document.getElementById('crypto-form');
                if (cryptoForm) {
                    cryptoForm.addEventListener('submit', function(e) {
                        let valid = true;

                        if (!document.querySelector('.crypto-option.selected')) {
                            document.getElementById('crypto-select-error').style.display = 'block';
                            valid = false;
                        }

                        if (!screenshotInput || !screenshotInput.files || !screenshotInput.files[0]) {
                            document.getElementById('screenshot-error').style.display = 'block';
                            valid = false;
                        }

                        if (!valid) {
                            e.preventDefault();
                            document.getElementById('crypto-select-error').closest('.step-section')
                                .scrollIntoView({
                                    behavior: 'smooth',
                                    block: 'start'
                                });
                        }
                    });
                }

                // ── Gift Card: Photo Preview ─────────────────────────────────────────────
                const giftInput = document.getElementById('gift-photo-input');
                if (giftInput) {
                    giftInput.addEventListener('change', function() {
                        if (this.files && this.files[0]) {
                            const file = this.files[0];
                            if (file.size > 5 * 1024 * 1024) {
                                alert('File size exceeds 5MB. Please choose a smaller image.');
                                this.value = '';
                                return;
                            }
                            const reader = new FileReader();
                            reader.onload = e => {
                                document.getElementById('gift-preview-img').src = e.target.result;
                                document.getElementById('gift-preview-filename').textContent = file.name;
                                document.getElementById('gift-upload-placeholder').style.display = 'none';
                                document.getElementById('gift-upload-preview').style.display = 'block';
                            };
                            reader.readAsDataURL(file);
                        }
                    });
                }

                // ── Gift Card: Value vs Total Indicator ──────────────────────────────────
                const valueInput = document.getElementById('gift-card-value-input');
                if (valueInput) {
                    valueInput.addEventListener('input', function() {
                        const entered = parseFloat(this.value) || 0;
                        const el = document.getElementById('value-check');
                        el.style.display = entered > 0 ? 'block' : 'none';

                        if (entered < orderTotal) {
                            el.innerHTML = `<span class="text-warning"><i class="fas fa-exclamation-triangle me-1"></i>
                    You entered <strong>$${entered.toFixed(2)}</strong> — order total is
                    <strong>$${orderTotal.toFixed(2)}</strong>. You may need multiple cards.</span>`;
                        } else if (entered === orderTotal) {
                            el.innerHTML = `<span class="text-success"><i class="fas fa-check-circle me-1"></i>
                    Card value matches the order total.</span>`;
                        } else {
                            el.innerHTML = `<span class="text-info"><i class="fas fa-info-circle me-1"></i>
                    Card value exceeds the order total — the difference will be treated as overpayment.</span>`;
                        }
                    });
                }

            });

            function clearCryptoPreview() {
                document.getElementById('screenshot-input').value = '';
                document.getElementById('upload-placeholder').style.display = 'block';
                document.getElementById('upload-preview').style.display = 'none';
            }

            function clearGiftPreview() {
                document.getElementById('gift-photo-input').value = '';
                document.getElementById('gift-upload-placeholder').style.display = 'block';
                document.getElementById('gift-upload-preview').style.display = 'none';
            }
        </script>
    <?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/ozil/notrace/resources/views/user-payment-confirm.blade.php ENDPATH**/ ?>