<?php $__env->startSection('content'); ?>
<div class="main-content">

    <div class="container-fluid py-4 px-4">

        <!-- Page Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2 class="mb-1" style="color:#1a1a2e; font-weight:700;">
                    <i class="fab fa-bitcoin me-2" style="color:#f7931a;"></i> Payment Methods
                </h2>
                <p class="text-muted mb-0">Manage crypto wallet addresses shown to customers at checkout</p>
            </div>
            <button class="btn btn-warning px-4" data-bs-toggle="modal" data-bs-target="#addCryptoModal">
                <i class="fas fa-plus me-2"></i> Add Wallet
            </button>
        </div>

        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Crypto Wallets Table -->
        <div class="card shadow-sm border-0">
            <div class="card-header py-3" style="background:#1a1a2e; border-radius:10px 10px 0 0;">
                <h5 class="mb-0 text-white">
                    <i class="fab fa-bitcoin me-2" style="color:#f7931a;"></i> Crypto Wallets
                </h5>
            </div>
            <div class="card-body p-0">
                <?php if($cryptoWallets->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead style="background:#f8f9fa;">
                                <tr>
                                    <th class="ps-4" style="width:180px;">Currency</th>
                                    <th style="width:220px;">Network</th>
                                    <th>Wallet Address</th>
                                    <th class="text-center" style="width:110px;">Status</th>
                                    <th class="text-center" style="width:120px;">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $cryptoWallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="ps-4">
                                        <span style="background:<?php echo e($wallet->badge_color ?? '#f7931a'); ?>20;
                                                     color:<?php echo e($wallet->badge_color ?? '#f7931a'); ?>;
                                                     padding:5px 14px; border-radius:20px;
                                                     font-weight:700; font-size:13px;">
                                            <?php echo e($wallet->currency); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-light text-dark border"
                                              style="font-size:12px; padding:6px 12px;">
                                            <?php echo e($wallet->network); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center gap-2">
                                            <code style="font-size:13px; background:#f4f4f4; padding:5px 10px;
                                                         border-radius:6px; flex:1; overflow:hidden;
                                                         text-overflow:ellipsis; white-space:nowrap;
                                                         max-width:380px; display:block;">
                                                <?php echo e($wallet->address); ?>

                                            </code>
                                            <button class="btn btn-sm btn-outline-secondary copy-btn"
                                                    data-address="<?php echo e($wallet->address); ?>" title="Copy address">
                                                <i class="far fa-copy"></i>
                                            </button>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge <?php echo e($wallet->is_active ? 'bg-success' : 'bg-secondary'); ?>"
                                              style="padding:6px 14px; font-size:12px;">
                                            <?php echo e($wallet->is_active ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <div class="d-flex justify-content-center gap-2">
                                            <button class="btn btn-sm btn-outline-primary edit-crypto-btn"
                                                    data-id="<?php echo e($wallet->id); ?>"
                                                    data-currency="<?php echo e($wallet->currency); ?>"
                                                    data-network="<?php echo e($wallet->network); ?>"
                                                    data-address="<?php echo e($wallet->address); ?>"
                                                    data-color="<?php echo e($wallet->badge_color); ?>"
                                                    data-active="<?php echo e($wallet->is_active); ?>"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#editCryptoModal"
                                                    title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <form action="<?php echo e(route('admin.payment.crypto.destroy', $wallet->id)); ?>"
                                                  method="POST"
                                                  onsubmit="return confirm('Delete this wallet?')">
                                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-sm btn-outline-danger" type="submit" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="fab fa-bitcoin fa-4x mb-3" style="color:#e0e0e0;"></i>
                        <h5 class="text-muted">No crypto wallets added yet</h5>
                        <p class="text-muted mb-4">Add your first wallet address to accept crypto payments.</p>
                        <button class="btn btn-warning px-4" data-bs-toggle="modal" data-bs-target="#addCryptoModal">
                            <i class="fas fa-plus me-2"></i> Add First Wallet
                        </button>
                    </div>
                <?php endif; ?>
            </div>
        </div>

    </div>
</div>


<!-- ══════════════════════════════════════
     ADD CRYPTO MODAL
══════════════════════════════════════ -->
<div class="modal fade" id="addCryptoModal" tabindex="-1">
    <div class="modal-dialog modal-md">
        <div class="modal-content border-0 shadow">
            <form action="<?php echo e(route('admin.payment.crypto.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header" style="background:#1a1a2e; color:#fff; border-radius:8px 8px 0 0;">
                    <h5 class="modal-title">
                        <i class="fab fa-bitcoin me-2" style="color:#f7931a;"></i> Add Crypto Wallet
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Currency <span class="text-danger">*</span></label>
                        <input type="text" name="currency" class="form-control"
                               placeholder="e.g. Bitcoin (BTC), USDT, Ethereum (ETH)" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Network <span class="text-danger">*</span></label>
                        <input type="text" name="network" class="form-control"
                               placeholder="e.g. Tron (TRC-20), Ethereum (ERC-20), BNB Smart Chain" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Wallet Address <span class="text-danger">*</span></label>
                        <input type="text" name="address" class="form-control font-monospace"
                               placeholder="Enter wallet address" required>
                        <small class="text-muted">
                            <i class="fas fa-exclamation-triangle text-warning me-1"></i>
                            Double-check the address before saving.
                        </small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Badge Color</label>
                        <div class="d-flex align-items-center gap-3">
                            <input type="color" name="badge_color" class="form-control form-control-color"
                                   value="#f7931a" style="width:60px; height:40px;">
                            <small class="text-muted">Display color for the currency label</small>
                        </div>
                    </div>
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="is_active"
                               value="1" checked id="cryptoActive">
                        <label class="form-check-label" for="cryptoActive">
                            Active <span class="text-muted">(visible to customers)</span>
                        </label>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning px-4">
                        <i class="fas fa-save me-2"></i> Save Wallet
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- ══════════════════════════════════════
     EDIT CRYPTO MODAL
══════════════════════════════════════ -->
<div class="modal fade" id="editCryptoModal" tabindex="-1">
    <div class="modal-dialog modal-md">
        <div class="modal-content border-0 shadow">
            <form action="<?php echo e(route('admin.payment.crypto.update')); ?>" method="POST">
                <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
                <input type="hidden" name="id" id="edit-crypto-id">
                <div class="modal-header" style="background:#1a1a2e; color:#fff; border-radius:8px 8px 0 0;">
                    <h5 class="modal-title">
                        <i class="fas fa-edit me-2"></i> Edit Crypto Wallet
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Currency</label>
                        <input type="text" name="currency" id="edit-crypto-currency"
                               class="form-control"
                               placeholder="e.g. Bitcoin (BTC), USDT, Ethereum (ETH)" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Network</label>
                        <input type="text" name="network" id="edit-crypto-network"
                               class="form-control"
                               placeholder="e.g. Tron (TRC-20), ERC-20" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Wallet Address</label>
                        <input type="text" name="address" id="edit-crypto-address"
                               class="form-control font-monospace" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Badge Color</label>
                        <div class="d-flex align-items-center gap-3">
                            <input type="color" name="badge_color" id="edit-crypto-color"
                                   class="form-control form-control-color"
                                   value="#f7931a" style="width:60px; height:40px;">
                            <small class="text-muted">Display color for the currency label</small>
                        </div>
                    </div>
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="is_active"
                               value="1" id="edit-crypto-active">
                        <label class="form-check-label" for="edit-crypto-active">Active</label>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary px-4">
                        <i class="fas fa-save me-2"></i> Update Wallet
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>


<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {

    // ── Copy wallet address ──────────────────────────────────────────────────
    document.querySelectorAll('.copy-btn').forEach(btn => {
        btn.addEventListener('click', function () {
            navigator.clipboard.writeText(this.dataset.address).then(() => {
                this.innerHTML = '<i class="fas fa-check text-success"></i>';
                setTimeout(() => this.innerHTML = '<i class="far fa-copy"></i>', 1500);
            });
        });
    });

    // ── Populate Edit Modal ──────────────────────────────────────────────────
    document.querySelectorAll('.edit-crypto-btn').forEach(btn => {
        btn.addEventListener('click', function () {
            document.getElementById('edit-crypto-id').value       = this.dataset.id;
            document.getElementById('edit-crypto-currency').value = this.dataset.currency;
            document.getElementById('edit-crypto-network').value  = this.dataset.network;
            document.getElementById('edit-crypto-address').value  = this.dataset.address;
            document.getElementById('edit-crypto-color').value    = this.dataset.color || '#f7931a';
            document.getElementById('edit-crypto-active').checked = this.dataset.active == 1;
        });
    });

});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/ozil/notrace/resources/views/payment-method.blade.php ENDPATH**/ ?>