<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Notrace Trip</title>
    <meta name="robots" content="noindex, follow" />
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link rel="shortcut icon" href="<?php echo e(asset('img/favicon.png')); ?>" type="image/x-icon" />
    <link rel="stylesheet" href="<?php echo e(asset('css/font-icons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/plugins.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/responsive.css')); ?>">

    <style>
        .logout-btn {
            background: none; border: none; padding: 0; color: red; cursor: pointer;
        }
        .logout-btn:hover { color: darkred; }

        .ltn__utilize-mobile-menu.ltn__utilize-open {
            opacity: 1 !important; visibility: visible !important; transform: translateX(0) !important;
        }
        .ltn__utilize-mobile-menu {
            position: fixed; top: 0; left: 0; width: 320px; height: 100%;
            background: #fff; z-index: 9999; transform: translateX(-100%); transition: all 0.3s ease;
        }
        .ltn__utilize-menu ul { list-style: none; padding: 0; margin: 20px 0; }
        .ltn__utilize-menu ul li { border-bottom: 1px solid #f0f0f0; }
        .ltn__utilize-menu ul li a { display: block; padding: 15px 30px; color: #333; text-decoration: none; font-size: 16px; }
        .ltn__utilize-menu ul li a:hover { background: #f8f8f8; color: #0a9a73; }

        .ltn__utilize-overlay {
            position: fixed; top: 0; left: 0; width: 100%; height: 100%;
            background: rgba(0,0,0,0.5); z-index: 9998; opacity: 0; visibility: hidden; transition: all 0.3s ease;
        }
        .ltn__utilize-overlay.ltn__utilize-open { opacity: 1 !important; visibility: visible !important; }

        /* Cart icon badge */
        .mini-cart-icon sup {
            background: #0a9a73; color: #fff; border-radius: 50%;
            padding: 2px 6px; font-size: 11px; font-weight: 700;
        }

        /* Cart Plus Minus */
        .cart-plus-minus { position: relative; width: 120px; height: 50px; overflow: hidden; display: inline-block; }
        .cart-plus-minus .cart-plus-minus-box { width: 100%; height: 100%; border: 1px solid #e1e1e1; text-align: center; font-size: 16px; font-weight: 500; color: #333; background: #fff; padding: 0 40px; }
        .cart-plus-minus .qtybutton { position: absolute; top: 0; width: 35px; height: 100%; border: none; background: #f8f8f8; color: #333; cursor: pointer; font-size: 18px; font-weight: 600; transition: all 0.3s ease; }
        .cart-plus-minus .qtybutton:hover { background: #0a9a73; color: #fff; }
        .cart-plus-minus .inc { right: 0; }
        .cart-plus-minus .dec { left: 0; }

        .modal-product-info h3, .modal-product-info h5 { color: #0a9a73; margin-bottom: 15px; }
        .modal-product-info .product-price { font-size: 24px; font-weight: 700; color: #0a9a73; margin: 15px 0; }
        .modal-product-info .product-price del { font-size: 18px; color: #999; margin-left: 10px; }
        .added-cart { color: #0a9a73; font-weight: 600; margin: 20px 0; }
        .added-cart i { margin-right: 5px; }
        #quick_view_modal .modal-dialog { max-width: 900px; }
        #quick_view_modal .modal-product-img img { width: 100%; height: auto; border-radius: 5px; }
        .modal-product-meta ul { list-style: none; padding: 0; margin: 20px 0; }
        .modal-product-meta ul li { margin-bottom: 10px; font-size: 14px; }
        .modal-product-meta strong { color: #333; margin-right: 10px; }
        .ltn__product-details-menu-2 ul { display: flex; gap: 15px; align-items: center; flex-wrap: wrap; }
        .ltn__product-details-menu-3 ul { display: flex; gap: 20px; }
        .ltn__product-details-menu-3 a { display: flex; align-items: center; gap: 8px; color: #666; transition: color 0.3s ease; }
        .ltn__product-details-menu-3 a:hover { color: #0a9a73; }
    </style>
</head>

<body>
<div class="body-wrapper">

    <!-- HEADER -->
    <header class="ltn__header-area ltn__header-3">

        <div class="ltn__header-middle-area">
            <div class="container">
                <div class="row">
                    <div class="col">
                        <div class="site-logo">
                            <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('img/ntc_logo.png')); ?>" alt="Logo"></a>
                        </div>
                    </div>
                    <div class="col header-contact-serarch-column d-none d-lg-block">
                        <div class="header-contact-search">
                            <div class="header-search-2">
                                <form method="get" action="<?php echo e(route('shop')); ?>">
                                    <input type="text" name="search" placeholder="Search here..." />
                                    <button type="submit"><span><i class="icon-search"></i></span></button>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="ltn__header-options">
                            <ul>
                                <li class="d-lg-none">
                                    <div class="header-search-wrap">
                                        <div class="header-search-1">
                                            <div class="search-icon">
                                                <i class="icon-search for-search-show"></i>
                                                <i class="icon-cancel for-search-close"></i>
                                            </div>
                                        </div>
                                        <div class="header-search-1-form">
                                            <form method="get" action="<?php echo e(route('shop')); ?>">
                                                <input type="text" name="search" placeholder="Search here..." />
                                                <button type="submit"><span><i class="icon-search"></i></span></button>
                                            </form>
                                        </div>
                                    </div>
                                </li>
                                <li class="d-none---">
                                    <div class="ltn__drop-menu user-menu">
                                        <ul>
                                            <li>
                                                <a href="#"><i class="icon-user"></i></a>
                                                <ul>
                                                    <?php if(auth()->guard()->check()): ?>
                                                        <li><?php echo e(Auth::user()->name); ?></li>
                                                        <li><a href="#">Profile</a></li>
                                                        <li><a href="<?php echo e(route('orders.index')); ?>">My Orders</a></li>
                                                        <li>
                                                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                                                <?php echo csrf_field(); ?>
                                                                <button type="submit" class="logout-btn">Logout</button>
                                                            </form>
                                                        </li>
                                                    <?php else: ?>
                                                        <li><a href="<?php echo e(route('login')); ?>">Sign in</a></li>
                                                        <li><a href="<?php echo e(route('register')); ?>">Register</a></li>
                                                    <?php endif; ?>
                                                </ul>
                                            </li>
                                        </ul>
                                    </div>
                                </li>

                                <!-- ── CART ICON ── -->
                                <li>
                                    <div class="mini-cart-icon mini-cart-icon-2">
                                        <a href="<?php echo e(route('cart.index')); ?>">
                                            <span class="mini-cart-icon">
                                                <i class="icon-shopping-cart"></i>
                                                <sup><?php echo e($cartCount); ?></sup>
                                            </span>
                                            <h6>
                                                <span>Your Cart</span>
                                                <span class="ltn__secondary-color">$<?php echo e(number_format($cartTotal, 2)); ?></span>
                                            </h6>
                                        </a>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Desktop Nav -->
        <div class="header-bottom-area ltn__border-top ltn__header-sticky ltn__sticky-bg-secondary ltn__secondary-bg section-bg-1 menu-color-white d-none d-lg-block">
            <div class="container">
                <div class="row">
                    <div class="col header-menu-column justify-content-center">
                        <div class="sticky-logo">
                            <div class="site-logo">
                                <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('img/ntgreen.jpeg')); ?>" alt="Logo"></a>
                            </div>
                        </div>
                        <div class="header-menu header-menu-2">
                            <nav>
                                <div class="ltn__main-menu">
                                    <ul>
                                        <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                                        <li><a href="<?php echo e(route('shop')); ?>">Shop</a></li>
                                        <li><a href="<?php echo e(route('shop')); ?>">Drugs</a></li>
                                    </ul>
                                </div>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- MOBILE MENU TOGGLE -->
    <div class="mobile-header-menu-fullwidth mb-30 d-block d-lg-none">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="mobile-menu-toggle d-lg-none">
                        <span>MENU</span>
                        <a href="#ltn__utilize-mobile-menu" class="ltn__utilize-toggle">
                            <svg viewBox="0 0 800 600">
                                <path d="M300,220 C300,220 520,220 540,220 C740,220 640,540 520,420 C440,340 300,200 300,200" id="top"></path>
                                <path d="M300,320 L540,320" id="middle"></path>
                                <path d="M300,210 C300,210 520,210 540,210 C740,210 640,530 520,410 C440,330 300,190 300,190" id="bottom" transform="translate(480, 320) scale(1, -1) translate(-480, -318)"></path>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu Drawer -->
    <div id="ltn__utilize-mobile-menu" class="ltn__utilize ltn__utilize-mobile-menu">
        <div class="ltn__utilize-menu-inner ltn__scrollbar">
            <div class="ltn__utilize-menu-head">
                <div class="site-logo">
                    <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('img/logo.png')); ?>" alt="Logo"></a>
                </div>
                <button class="ltn__utilize-close">×</button>
            </div>
            <div class="ltn__utilize-menu-search-form">
                <form action="<?php echo e(route('shop')); ?>" method="GET">
                    <input type="text" name="search" placeholder="Search...">
                    <button type="submit"><i class="fas fa-search"></i></button>
                </form>
            </div>
            <div class="ltn__utilize-menu">
                <ul>
                    <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li><a href="<?php echo e(route('shop')); ?>">Shop</a></li>
                    <li><a href="<?php echo e(route('shop')); ?>">Drugs</a></li>
                    <?php if(auth()->guard()->check()): ?>
                        <li><a href="<?php echo e(route('orders.index')); ?>">My Orders</a></li>
                    <?php endif; ?>
                </ul>
            </div>
            <div class="ltn__utilize-buttons ltn__utilize-buttons-2">
                <ul>
                    <li>
                        <?php if(auth()->guard()->check()): ?>
                            <a href="<?php echo e(route('orders.index')); ?>" title="My Orders">
                                <span class="utilize-btn-icon"><i class="far fa-box"></i></span>
                                My Orders
                            </a>
                        <?php else: ?>
                            <a href="<?php echo e(route('login')); ?>" title="My Account">
                                <span class="utilize-btn-icon"><i class="far fa-user"></i></span>
                                My Account
                            </a>
                        <?php endif; ?>
                    </li>
                    <li>
                        
                        <a href="<?php echo e(route('cart.index')); ?>" title="Shopping Cart">
                            <span class="utilize-btn-icon">
                                <i class="fas fa-shopping-cart"></i>
                                <sup><?php echo e($cartCount); ?></sup>
                            </span>
                            Shopping Cart ($<?php echo e(number_format($cartTotal, 2)); ?>)
                        </a>
                    </li>
                </ul>
            </div>

        </div>
    </div>
    <div class="ltn__utilize-overlay"></div>

    <?php echo $__env->yieldContent('content'); ?>

    <!-- FOOTER -->
    <footer class="ltn__footer-area">
        <div class="footer-top-area section-bg-2 plr--5">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-xl-3 col-md-6 col-sm-6 col-12">
                        <div class="footer-widget footer-about-widget">
                            <div class="footer-logo">
                                <div class="site-logo">
                                    <img src="<?php echo e(asset('img/ntgreen.jpeg')); ?>" alt="Logo">
                                </div>
                            </div>
                            <p>Your trusted source for quality health and pharmaceutical products.</p>


                        </div>
                    </div>
                    <div class="col-xl-2 col-md-6 col-sm-6 col-12">
                        <div class="footer-widget footer-menu-widget clearfix">
                            <h4 class="footer-title">Quick Links</h4>
                            <div class="footer-menu">
                                <ul>
                                    <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                                    <li><a href="<?php echo e(route('shop')); ?>">Shop</a></li>
                                    <li><a href="#">Contact</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-2 col-md-6 col-sm-6 col-12">
                        <div class="footer-widget footer-menu-widget clearfix">
                            <h4 class="footer-title">Customer Care</h4>
                            <div class="footer-menu">
                                <ul>
                                    <li><a href="<?php echo e(route('login')); ?>">My Account</a></li>
                                    <li><a href="<?php echo e(route('orders.index')); ?>">Order Tracking</a></li>
                                    <li><a href="#">Contact Us</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="ltn__copyright-area ltn__copyright-2 section-bg-7 plr--5">
            <div class="container-fluid ltn__border-top-2">
                <div class="row">
                    <div class="col-md-6 col-12">
                        <div class="ltn__copyright-design clearfix">
                            <p>All Rights Reserved @ Notrace Trip <span class="current-year"><?php echo e(date('Y')); ?></span></p>
                        </div>
                    </div>
                    <div class="col-md-6 col-12 align-self-center">
                        <div class="ltn__copyright-menu text-end">
                            <ul>
                                <li><a href="#">Terms & Conditions</a></li>
                                <li><a href="#">Privacy Policy</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Quick View Modal -->
    <div class="ltn__modal-area ltn__quick-view-modal-area">
        <div class="modal fade" id="quick_view_modal" tabindex="-1">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="ltn__quick-view-modal-inner">
                            <div class="modal-product-item">
                                <div class="row">
                                    <div class="col-lg-6 col-12">
                                        <div class="modal-product-img">
                                            <img id="quick-view-image" src="<?php echo e(asset('img/product/default.png')); ?>" alt="Product">
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="modal-product-info">
                                            <div class="product-ratting">
                                                <ul>
                                                    <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                    <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                    <li><a href="#"><i class="fas fa-star"></i></a></li>
                                                    <li><a href="#"><i class="fas fa-star-half-alt"></i></a></li>
                                                    <li><a href="#"><i class="far fa-star"></i></a></li>
                                                </ul>
                                            </div>
                                            <h3 id="quick-view-name">Product Name</h3>
                                            <div class="product-price">
                                                <span id="quick-view-price">$0.00</span>
                                                <del id="quick-view-old-price" style="display:none;">$0.00</del>
                                            </div>
                                            <div class="modal-product-meta ltn__product-details-menu-1">
                                                <ul>
                                                    <li><strong>Category:</strong> <span id="quick-view-category">-</span></li>
                                                </ul>
                                            </div>
                                            <div class="ltn__product-details-menu-2">
                                                <ul>
                                                    <li>
                                                        <div class="cart-plus-minus">
                                                            <input type="text" value="01" name="qtybutton" class="cart-plus-minus-box">
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <a href="#" class="theme-btn-1 btn btn-effect-1" title="Add to Cart" onclick="addToCart(event)">
                                                            <i class="fas fa-shopping-cart"></i>
                                                            <span>ADD TO CART</span>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="ltn__product-details-menu-3">
                                                <ul>
                                                    <li>
                                                        <a href="#" class="add-to-wishlist" title="Wishlist" onclick="addToWishlist(event)">
                                                            <i class="far fa-heart"></i>
                                                            <span>Add to Wishlist</span>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <hr>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add To Cart Modal -->
    <div class="ltn__modal-area ltn__add-to-cart-modal-area">
        <div class="modal fade" id="add_to_cart_modal" tabindex="-1">
            <div class="modal-dialog modal-md" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="ltn__quick-view-modal-inner">
                            <div class="modal-product-item">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="modal-product-img">
                                            <img id="cart-modal-image" src="<?php echo e(asset('img/product/default.png')); ?>" alt="Product">
                                        </div>
                                        <div class="modal-product-info">
                                            <h5><a href="#" id="cart-modal-name">Product Name</a></h5>
                                            <p class="added-cart"><i class="fa fa-check-circle"></i> Successfully added to your Cart</p>
                                            <div class="btn-wrapper">
                                                <a href="<?php echo e(route('cart.index')); ?>" class="theme-btn-1 btn btn-effect-1">View Cart</a>
                                                <a href="<?php echo e(route('checkout')); ?>" class="theme-btn-2 btn btn-effect-2">Checkout</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Wishlist Modal -->
    <div class="ltn__modal-area ltn__add-to-cart-modal-area">
        <div class="modal fade" id="liton_wishlist_modal" tabindex="-1">
            <div class="modal-dialog modal-md" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="ltn__quick-view-modal-inner">
                            <div class="modal-product-item">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="modal-product-img">
                                            <img id="wishlist-modal-image" src="<?php echo e(asset('img/product/default.png')); ?>" alt="Product">
                                        </div>
                                        <div class="modal-product-info">
                                            <h5><a href="#" id="wishlist-modal-name">Product Name</a></h5>
                                            <p class="added-cart"><i class="fa fa-check-circle"></i> Successfully added to your Wishlist</p>
                                            <div class="btn-wrapper">
                                                <a href="#" class="theme-btn-1 btn btn-effect-1">View Wishlist</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div><!-- /.body-wrapper -->

<script src="<?php echo e(asset('js/plugins.js')); ?>"></script>
<script src="<?php echo e(asset('js/main.js')); ?>"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {

    // ── Mobile Menu ──────────────────────────────────────────────────────────
    const menuToggle = document.querySelector('.ltn__utilize-toggle');
    const mobileMenu = document.querySelector('#ltn__utilize-mobile-menu');
    const overlay    = document.querySelector('.ltn__utilize-overlay');
    const closeBtn   = document.querySelector('#ltn__utilize-mobile-menu .ltn__utilize-close');

    if (menuToggle && mobileMenu) {
        menuToggle.addEventListener('click', function (e) {
            e.preventDefault();
            mobileMenu.classList.add('ltn__utilize-open');
            overlay.classList.add('ltn__utilize-open');
            document.body.style.overflow = 'hidden';
        });
    }
    if (closeBtn) {
        closeBtn.addEventListener('click', function () {
            mobileMenu.classList.remove('ltn__utilize-open');
            overlay.classList.remove('ltn__utilize-open');
            document.body.style.overflow = '';
        });
    }
    if (overlay) {
        overlay.addEventListener('click', function () {
            mobileMenu.classList.remove('ltn__utilize-open');
            overlay.classList.remove('ltn__utilize-open');
            document.body.style.overflow = '';
        });
    }

    // ── Quick View Modal ─────────────────────────────────────────────────────
    document.querySelectorAll('[data-bs-target="#quick_view_modal"]').forEach(button => {
        button.addEventListener('click', function (e) {
            e.preventDefault();
            const card = this.closest('.ltn__product-item');
            if (!card) return;

            const img   = card.querySelector('.product-img img');
            const name  = card.querySelector('.product-title a');
            const price = card.querySelector('.product-price span');
            const old   = card.querySelector('.product-price del');

            if (img)   { document.getElementById('quick-view-image').src = img.src; }
            if (name)  { document.getElementById('quick-view-name').textContent = name.textContent; }
            if (price) { document.getElementById('quick-view-price').textContent = price.textContent; }
            if (old) {
                document.getElementById('quick-view-old-price').textContent = old.textContent;
                document.getElementById('quick-view-old-price').style.display = 'inline';
            } else {
                document.getElementById('quick-view-old-price').style.display = 'none';
            }
        });
    });

    // ── Cart Plus/Minus ──────────────────────────────────────────────────────
    document.querySelectorAll('.cart-plus-minus').forEach(el => {
        const input = el.querySelector('.cart-plus-minus-box');
        if (el.querySelector('.inc')) return; // already initialised

        const inc = document.createElement('button');
        inc.className = 'inc qtybutton'; inc.textContent = '+'; inc.type = 'button';
        const dec = document.createElement('button');
        dec.className = 'dec qtybutton'; dec.textContent = '-'; dec.type = 'button';

        el.appendChild(dec);
        el.appendChild(inc);

        inc.addEventListener('click', () => { input.value = (parseInt(input.value) || 1) + 1; });
        dec.addEventListener('click', () => {
            const v = parseInt(input.value) || 1;
            if (v > 1) input.value = v - 1;
        });
    });
});

// ── Add to Cart ───────────────────────────────────────────────────────────────
function addToCart(event) {
    event.preventDefault();
    const name  = document.getElementById('quick-view-name').textContent;
    const image = document.getElementById('quick-view-image').src;

    const qv = bootstrap.Modal.getInstance(document.getElementById('quick_view_modal'));
    if (qv) qv.hide();

    document.getElementById('cart-modal-name').textContent = name;
    document.getElementById('cart-modal-image').src = image;
    new bootstrap.Modal(document.getElementById('add_to_cart_modal')).show();
}

// ── Add to Wishlist ───────────────────────────────────────────────────────────
function addToWishlist(event) {
    event.preventDefault();
    const name  = document.getElementById('quick-view-name').textContent;
    const image = document.getElementById('quick-view-image').src;

    const qv = bootstrap.Modal.getInstance(document.getElementById('quick_view_modal'));
    if (qv) qv.hide();

    document.getElementById('wishlist-modal-name').textContent = name;
    document.getElementById('wishlist-modal-image').src = image;
    new bootstrap.Modal(document.getElementById('liton_wishlist_modal')).show();
}
</script>

<?php echo $__env->yieldPushContent('scripts'); ?>

</body>
</html>
<?php /**PATH /Users/ozil/notrace/resources/views/layouts/guest.blade.php ENDPATH**/ ?>