<?php $__env->startSection('content'); ?>
<style>
    .ltn__shop-details-small-img {
    display: flex !important;
    gap: 10px;
    margin-top: 15px;
    flex-wrap: wrap;
}
.ltn__shop-details-small-img .slick-slide-item {
    display: flex !important;
    gap: 10px;
    flex-wrap: wrap;
}
</style>

<!-- BREADCRUMB AREA START -->
<div class="ltn__breadcrumb-area text-left bg-overlay-white-30 bg-image" data-bs-bg="<?php echo e(asset('img/bg/14.jpg')); ?>">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="ltn__breadcrumb-inner">
                    <h1 class="page-title">Product Details</h1>
                    <div class="ltn__breadcrumb-list">
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>"><span class="ltn__secondary-color"><i class="fas fa-home"></i></span> Home</a></li>
                            <li><a href="<?php echo e(route('shop')); ?>">Shop</a></li>
                            <li><?php echo e($product->name); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- BREADCRUMB AREA END -->

<!-- SHOP DETAILS AREA START -->
<div class="ltn__shop-details-area pb-10">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 col-md-12">
                <div class="ltn__shop-details-inner ltn__page-details-inner mb-60">
                    <div class="ltn__blog-meta">
                        <ul>
                            <?php if($product->is_on_sale): ?>
                                <li class="ltn__blog-category">
                                    <a class="bg-orange" href="#">SALE!</a>
                                </li>
                            <?php endif; ?>
                            <?php if($product->category): ?>
                                <li class="ltn__blog-category">
                                    <a href="<?php echo e(route('shop.category', $product->category->slug)); ?>"><?php echo e($product->category->name); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <h1><?php echo e($product->name); ?></h1>
                    <label>
                        <span class="ltn__secondary-color"><i class="fas fa-heart"></i></span>
                        <?php echo e($product->stock_quantity ?? $product->quantity ?? 0); ?> in stock
                    </label>

                    <div class="ltn__shop-details-img-gallery">
                        <div class="ltn__shop-details-large-img">
                            <div class="single-large-img">
                                <?php if($product->images->count() > 0): ?>
                                    <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e(asset('storage/' . $image->image)); ?>" data-rel="lightcase:myCollection">
                                            <img id="main-image-<?php echo e($index); ?>"
                                                 src="<?php echo e(asset('storage/' . $image->image)); ?>"
                                                 alt="<?php echo e($product->name); ?>"
                                                 style="<?php echo e($index === 0 ? '' : 'display: none;'); ?>">
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <a href="<?php echo e(asset('img/product/default.png')); ?>" data-rel="lightcase:myCollection">
                                        <img src="<?php echo e(asset('img/product/default.png')); ?>" alt="<?php echo e($product->name); ?>">
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <?php if($product->images->count() > 1): ?>
                            <div class="ltn__shop-details-small-img">
                                    <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="#"
                                           class="small-img-trigger <?php echo e($index === 0 ? 'active' : ''); ?>"
                                           data-index="<?php echo e($index); ?>"
                                           onclick="changeMainImage(event, <?php echo e($index); ?>)">
                                            <img src="<?php echo e(asset('storage/' . $image->image)); ?>" alt="<?php echo e($product->name); ?>">
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="modal-product-meta ltn__product-details-menu-1">
                        <ul>

                            <li>
                                <strong>Categories:</strong>
                                <span>
                                    <?php if($product->category): ?>
                                        <a href="<?php echo e(route('shop.category', $product->category->slug)); ?>"><?php echo e($product->category->name); ?></a>
                                    <?php else: ?>
                                        Uncategorized
                                    <?php endif; ?>
                                </span>
                            </li>
                        </ul>
                    </div>

                    <h4 class="title-2">Product Description</h4>
                    <div class="ltn__shop-details-tab-content-inner">
                        <?php echo nl2br(e($product->description)); ?>

                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <aside class="sidebar ltn__shop-sidebar ltn__right-sidebar---">
                    <!-- Product Price Widget -->
                    <div class="widget ltn__menu-widget">
                        <h4 class="ltn__widget-title ltn__widget-title-border-2">Product Price</h4>
                        <div class="product-price-widget">
                            <div class="product-price">
                                <?php if($product->is_on_sale && $product->discount_price): ?>
                                    <span class="new-price">$<?php echo e(number_format($product->discount_price, 2)); ?></span>
                                    <del class="old-price">$<?php echo e(number_format($product->price, 2)); ?></del>
                                    <div class="discount-badge">
                                        Save <?php echo e(round((($product->price - $product->discount_price) / $product->price) * 100)); ?>%
                                    </div>
                                <?php else: ?>
                                    <span class="new-price">$<?php echo e(number_format($product->price, 2)); ?></span>
                                <?php endif; ?>
                            </div>

                            <!-- Product Rating -->
                            <div class="product-ratting mt-3">
                                <ul>
                                    <li><a href="#"><i class="fas fa-star"></i></a></li>
                                    <li><a href="#"><i class="fas fa-star"></i></a></li>
                                    <li><a href="#"><i class="fas fa-star"></i></a></li>
                                    <li><a href="#"><i class="fas fa-star-half-alt"></i></a></li>
                                    <li><a href="#"><i class="far fa-star"></i></a></li>
                                    <li class="review-total"> <a href="#"> ( 95 Reviews )</a></li>
                                </ul>
                            </div>

                            <!-- Quantity & Add to Cart -->
                            <div class="ltn__product-details-menu-2 mt-4">
                                <ul>
                                    <li>
                                        <div class="cart-plus-minus">
                                            <input type="text" value="1" name="qtybutton" class="cart-plus-minus-box" id="product-qty">
                                        </div>
                                    </li>
                                </ul>
                            </div>

                            <div class="btn-wrapper mt-3">
                                <button id="add-to-cart-btn" class="theme-btn-1 btn btn-effect-1 w-100" data-product-id="<?php echo e($product->id); ?>">
                                    <i class="fas fa-shopping-cart"></i>
                                    <span>ADD TO CART</span>
                                </button>
                            </div>

                            <div class="ltn__product-details-menu-3 mt-3">
                                <ul>
                                    <li>
                                        <a href="#" class="add-to-wishlist-detail" id="wishlist-btn">
                                            <i class="far fa-heart"></i>
                                            <span>Add to Wishlist</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>

                            <!-- Stock Status -->
                            <div class="stock-status mt-3">
                                <?php
                                    $stock = $product->stock_quantity ?? $product->quantity ?? 0;
                                ?>

                            </div>



                        </div>
                    </div>

                    <!-- Banner Widget -->
                    <div class="widget ltn__banner-widget d-none go-top">
                        <a href="<?php echo e(route('shop')); ?>"><img src="<?php echo e(asset('img/banner/2.jpg')); ?>" alt="Banner Image"></a>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</div>
<!-- SHOP DETAILS AREA END -->

<!-- RELATED PRODUCTS AREA START -->
<?php if($relatedProducts->count() > 0): ?>
<div class="ltn__product-slider-area ltn__product-gutter pb-70">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="section-title-area ltn__section-title-2--- text-center">
                    <h6 class="section-subtitle section-subtitle-2 ltn__secondary-color">Related Products</h6>
                    <h1 class="section-title">You May Also Like</h1>
                </div>
            </div>
        </div>
        <div class="row ltn__product-slider-item-four-active-full-width slick-arrow-1">
            <?php $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-12">
                    <div class="ltn__product-item ltn__product-item-3 text-center" data-product-id="<?php echo e($relatedProduct->id); ?>">
                        <div class="product-img">
                            <a href="<?php echo e(route('product.show', $relatedProduct->slug)); ?>">
                                <?php if($relatedProduct->images->count() > 0): ?>
                                    <img src="<?php echo e(asset('storage/' . $relatedProduct->images->first()->image)); ?>" alt="<?php echo e($relatedProduct->name); ?>">
                                <?php else: ?>
                                    <img src="<?php echo e(asset('img/product/default.png')); ?>" alt="<?php echo e($relatedProduct->name); ?>">
                                <?php endif; ?>
                            </a>
                            <?php if($relatedProduct->is_on_sale): ?>
                                <div class="product-badge">
                                    <ul>
                                        <li class="sale-badge bg-red">-<?php echo e(round((($relatedProduct->price - $relatedProduct->discount_price) / $relatedProduct->price) * 100)); ?>%</li>
                                    </ul>
                                </div>
                            <?php endif; ?>
                            <div class="product-hover-action">
                                <div class="product-action-inner">
                                    <ul>
                                        <li><a href="#" title="Add to Cart" class="add-to-cart-btn" data-product-id="<?php echo e($relatedProduct->id); ?>"><i class="fas fa-shopping-cart"></i></a></li>
                                        <li><a href="#" title="Wishlist"><i class="far fa-heart"></i></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="product-info">
                            <h2 class="product-title"><a href="<?php echo e(route('product.show', $relatedProduct->slug)); ?>"><?php echo e($relatedProduct->name); ?></a></h2>
                            <div class="product-price">
                                <?php if($relatedProduct->is_on_sale && $relatedProduct->discount_price): ?>
                                    <span>$<?php echo e(number_format($relatedProduct->discount_price, 2)); ?></span>
                                    <del>$<?php echo e(number_format($relatedProduct->price, 2)); ?></del>
                                <?php else: ?>
                                    <span>$<?php echo e(number_format($relatedProduct->price, 2)); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php endif; ?>
<!-- RELATED PRODUCTS AREA END -->

<!-- Custom Styles for Product Detail -->
<style>
    .ltn__shop-details-img-gallery { margin-bottom: 30px; }
    .ltn__shop-details-large-img img { width: 100%; height: auto; border-radius: 5px; border: 1px solid #e1e1e1; }
    .ltn__shop-details-small-img { display: flex; gap: 10px; margin-top: 15px; flex-wrap: wrap; }
    .small-img-trigger { width: 80px; height: 80px; border: 2px solid #e1e1e1; border-radius: 5px; overflow: hidden; cursor: pointer; transition: all 0.3s ease; display: block; }
    .small-img-trigger:hover, .small-img-trigger.active { border-color: #0a9a73; }
    .small-img-trigger img { width: 100%; height: 100%; object-fit: cover; }
    .product-price-widget { background: #f8f8f8; padding: 30px; border-radius: 10px; }
    .product-price { margin-bottom: 20px; }
    .product-price .new-price { font-size: 32px; font-weight: 700; color: #0a9a73; }
    .product-price .old-price { font-size: 20px; color: #999; margin-left: 10px; }
    .discount-badge { display: inline-block; background: #ff5722; color: white; padding: 5px 15px; border-radius: 20px; font-size: 14px; font-weight: 600; margin-top: 10px; }
    .stock-status { padding: 15px; background: white; border-radius: 5px; text-align: center; }
    .stock-status .in-stock { color: #0a9a73; font-weight: 600; }
    .stock-status .out-of-stock { color: #ff5722; font-weight: 600; }
    .add-to-wishlist-detail { display: flex; align-items: center; justify-content: center; gap: 10px; color: #666; transition: color 0.3s ease; padding: 10px; background: white; border-radius: 5px; text-decoration: none; }
    .add-to-wishlist-detail:hover { color: #0a9a73; }
    .ltn__shop-details-tab-content-inner { line-height: 1.8; color: #666; }
</style>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {

    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    const productId = <?php echo e($product->id); ?>;
    const productName = <?php echo json_encode($product->name, 15, 512) ?>;
    const productImage = '<?php echo e($product->images->count() > 0 ? asset("storage/" . $product->images->first()->image) : asset("img/product/default.png")); ?>';

    // =============================================
    // ADD TO CART - Main product button
    // =============================================
    const addToCartBtn = document.getElementById('add-to-cart-btn');

    if (addToCartBtn) {
        addToCartBtn.addEventListener('click', function(e) {
            e.preventDefault();

            const qtyInput = document.getElementById('product-qty');
            const quantity = parseInt(qtyInput ? qtyInput.value : 1) || 1;

            console.log('Adding to cart:', { productId, quantity });

            // Loading state
            const originalHTML = this.innerHTML;
            this.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Adding...';
            this.disabled = true;

            fetch('/cart/add', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                },
                body: JSON.stringify({
                    product_id: productId,
                    quantity: quantity
                })
            })
            .then(response => {
                console.log('Status:', response.status);
                return response.json();
            })
            .then(data => {
                console.log('Response:', data);

                // Reset button
                this.innerHTML = originalHTML;
                this.disabled = false;

                if (data.success) {
                    // Update cart count in header
                    document.querySelectorAll('.mini-cart-icon sup').forEach(el => {
                        el.textContent = data.cart_count;
                    });

                    // Update cart total in header
                    document.querySelectorAll('.ltn__secondary-color').forEach(el => {
                        if (el.closest('.mini-cart-icon-2')) {
                            el.textContent = '$' + data.cart_total;
                        }
                    });

                    // Show success modal
                    document.getElementById('cart-modal-name').textContent = productName;
                    document.getElementById('cart-modal-image').src = productImage;

                    const modal = new bootstrap.Modal(document.getElementById('add_to_cart_modal'));
                    modal.show();

                } else {
                    alert(data.message || 'Failed to add to cart. Please try again.');
                }
            })
            .catch(error => {
                this.innerHTML = originalHTML;
                this.disabled = false;
                console.error('Cart error:', error);
                alert('Something went wrong. Please try again.');
            });
        });
    }

    // =============================================
    // WISHLIST button
    // =============================================
    const wishlistBtn = document.getElementById('wishlist-btn');
    if (wishlistBtn) {
        wishlistBtn.addEventListener('click', function(e) {
            e.preventDefault();
            document.getElementById('wishlist-modal-name').textContent = productName;
            document.getElementById('wishlist-modal-image').src = productImage;
            const modal = new bootstrap.Modal(document.getElementById('liton_wishlist_modal'));
            modal.show();
        });
    }

    // =============================================
    // IMAGE GALLERY - thumbnail switching
    // =============================================
    window.changeMainImage = function(event, index) {
        event.preventDefault();
        document.querySelectorAll('[id^="main-image-"]').forEach(img => {
            img.style.display = 'none';
        });
        const target = document.getElementById('main-image-' + index);
        if (target) target.style.display = 'block';
        document.querySelectorAll('.small-img-trigger').forEach(trigger => {
            trigger.classList.remove('active');
        });
        event.currentTarget.classList.add('active');
    };

});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/ozil/notrace/resources/views/product-details.blade.php ENDPATH**/ ?>