<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Notrace Trip</title>
    <meta name="robots" content="noindex, follow" />
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="<?php echo e(asset('img/favicon.png')); ?>" type="image/x-icon" />
    <link rel="stylesheet" href="<?php echo e(asset('css/font-icons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/plugins.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/responsive.css')); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
        .logout-btn {
            background: none;
            border: none;
            padding: 0;
            color: red;
            cursor: pointer;
        }

        .logout-btn:hover {
            color: darkred;
        }

        .ltn__utilize-mobile-menu.ltn__utilize-open {
            opacity: 1 !important;
            visibility: visible !important;
            transform: translateX(0) !important;
        }

        .ltn__utilize-mobile-menu {
            position: fixed;
            top: 0;
            left: 0;
            width: 320px;
            height: 100%;
            background: #fff;
            z-index: 9999;
            transform: translateX(-100%);
            transition: all 0.3s ease;
        }

        .ltn__utilize-menu ul {
            list-style: none;
            padding: 0;
            margin: 20px 0;
        }

        .ltn__utilize-menu ul li {
            border-bottom: 1px solid #f0f0f0;
        }

        .ltn__utilize-menu ul li a {
            display: block;
            padding: 15px 30px;
            color: #333;
            text-decoration: none;
            font-size: 16px;
        }

        .ltn__utilize-menu ul li a:hover {
            background: #f8f8f8;
            color: #0a9a73;
        }

        .ltn__utilize-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 9998;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .ltn__utilize-overlay.ltn__utilize-open {
            opacity: 1 !important;
            visibility: visible !important;
        }

        /* ── Cart badge ── */
        .mini-cart-icon sup {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 18px;
            height: 18px;
            padding: 0 4px;
            background: #0a9a73;
            color: #fff;
            border-radius: 50%;
            font-size: 11px;
            font-weight: 700;
            line-height: 1;
        }

        .modal-product-info h3,
        .modal-product-info h5 {
            color: #0a9a73;
            margin-bottom: 15px;
        }

        .modal-product-info .product-price {
            font-size: 24px;
            font-weight: 700;
            color: #0a9a73;
            margin: 15px 0;
        }

        .modal-product-info .product-price del {
            font-size: 18px;
            color: #999;
            margin-left: 10px;
        }

        .added-cart {
            color: #0a9a73;
            font-weight: 600;
            margin: 20px 0;
        }

        .added-cart i {
            margin-right: 5px;
        }

        #quick_view_modal .modal-dialog {
            max-width: 900px;
        }

        #quick_view_modal .modal-product-img img {
            width: 100%;
            height: auto;
            border-radius: 5px;
        }

        .modal-product-meta ul {
            list-style: none;
            padding: 0;
            margin: 20px 0;
        }

        .modal-product-meta ul li {
            margin-bottom: 10px;
            font-size: 14px;
        }

        .modal-product-meta strong {
            color: #333;
            margin-right: 10px;
        }

        .ltn__product-details-menu-2 ul {
            display: flex;
            gap: 15px;
            align-items: center;
            flex-wrap: wrap;
        }

        .ltn__product-details-menu-3 ul {
            display: flex;
            gap: 20px;
        }

        .ltn__product-details-menu-3 a {
            display: flex;
            align-items: center;
            gap: 8px;
            color: #666;
            transition: color 0.3s ease;
            text-decoration: none;
        }

        .ltn__product-details-menu-3 a:hover {
            color: #0a9a73;
        }

        .modal-product-img-gallery {
            width: 100%;
            position: relative;
        }

        .modal-product-img-main {
            width: 100%;
            height: 400px;
            border: 1px solid #e1e1e1;
            border-radius: 8px;
            overflow: hidden;
            margin-bottom: 15px;
            background: #f8f8f8;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
        }

        .modal-product-img-main img {
            width: 100%;
            height: 100%;
            object-fit: contain;
            cursor: zoom-in;
        }

        .modal-img-arrow {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background: rgba(255, 255, 255, 0.9);
            border: 1px solid #e1e1e1;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            z-index: 10;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .modal-img-arrow:hover {
            background: #0a9a73;
            color: white;
            border-color: #0a9a73;
        }

        .modal-img-arrow.disabled {
            opacity: 0.3;
            cursor: not-allowed;
            pointer-events: none;
        }

        .modal-img-arrow-prev {
            left: 10px;
        }

        .modal-img-arrow-next {
            right: 10px;
        }

        .modal-img-arrow i {
            font-size: 18px;
        }

        .modal-img-counter {
            position: absolute;
            bottom: 10px;
            right: 10px;
            background: rgba(0, 0, 0, 0.7);
            color: white;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            z-index: 10;
        }

        .modal-product-img-thumbnails {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
            justify-content: center;
        }

        .modal-thumbnail {
            width: 70px;
            height: 70px;
            border: 2px solid #e1e1e1;
            border-radius: 5px;
            overflow: hidden;
            cursor: pointer;
            transition: all 0.3s ease;
            background: #fff;
        }

        .modal-thumbnail:hover,
        .modal-thumbnail.active {
            border-color: #0a9a73;
            transform: scale(1.05);
            box-shadow: 0 2px 8px rgba(10, 154, 115, 0.3);
        }

        .modal-thumbnail img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        #quick-view-stock {
            color: #0a9a73;
            font-weight: 600;
        }

        #quick-view-stock.out-of-stock {
            color: #ff5722;
        }
    </style>
</head>

<body>
    <div class="body-wrapper">

        <header class="ltn__header-area ltn__header-3">

            <!-- Top Bar -->
            <div class="ltn__header-top-area border-bottom">
                <div class="container">
                    <div class="row">
                        <div class="col-md-7">
                            <div class="ltn__top-bar-menu">
                                <ul>
                                    <?php if(auth()->guard()->check()): ?>
                                        <li><a href="mailto:<?php echo e(Auth::user()->email); ?>"><i class="icon-mail"></i>
                                                <?php echo e(Auth::user()->email); ?></a></li>
                                    <?php endif; ?>

                                </ul>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Middle Area -->
            <div class="ltn__header-middle-area">
                <div class="container">
                    <div class="row">
                        <div class="col">
                            <div class="site-logo">
                                <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('img/ntc_logo.png')); ?>"
                                        alt="Logo"></a>
                            </div>
                        </div>
                        <div class="col header-contact-serarch-column d-none d-lg-block">
                            <div class="header-contact-search">
                                <div class="header-feature-item">
                                    <div class="header-feature-icon"><i class="icon-call"></i></div>

                                </div>
                                <div class="header-search-2">
                                    <form method="get" action="<?php echo e(route('shop')); ?>">
                                        <input type="text" name="search" placeholder="Search here..." />
                                        <button type="submit"><span><i class="icon-search"></i></span></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="ltn__header-options">
                                <ul>
                                    <li class="d-lg-none">
                                        <div class="header-search-wrap">
                                            <div class="header-search-1">
                                                <div class="search-icon">
                                                    <i class="icon-search for-search-show"></i>
                                                    <i class="icon-cancel for-search-close"></i>
                                                </div>
                                            </div>
                                            <div class="header-search-1-form">
                                                <form method="get" action="<?php echo e(route('shop')); ?>">
                                                    <input type="text" name="search" placeholder="Search here..." />
                                                    <button type="submit"><span><i
                                                                class="icon-search"></i></span></button>
                                                </form>
                                            </div>
                                        </div>
                                    </li>
                                    <li class="d-none---">
                                        <div class="ltn__drop-menu user-menu">
                                            <ul>
                                                <li>
                                                    <i class="icon-user"></i>
                                                    <ul>
                                                        <?php if(auth()->guard()->check()): ?>
                                                            <li><?php echo e(Auth::user()->name); ?></li>
                                                            <li><a href="<?php echo e(route('orders.index')); ?>">Orders</a></li>

                                                            <li>
                                                                <form method="POST" action="<?php echo e(route('logout')); ?>">
                                                                    <?php echo csrf_field(); ?>
                                                                    <button type="submit"
                                                                        class="logout-btn">Logout</button>
                                                                </form>
                                                            </li>
                                                        <?php else: ?>
                                                            <li><a href="<?php echo e(route('login')); ?>">Login</a></li>
                                                            <li><a href="<?php echo e(route('register')); ?>">Register</a></li>
                                                        <?php endif; ?>
                                                    </ul>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>

                                    
                                    <li>
                                        <div class="mini-cart-icon mini-cart-icon-2" id="header-cart-wrap">
                                            <a href="<?php echo e(route('cart.index')); ?>">
                                                <span class="mini-cart-icon">
                                                    <i class="icon-shopping-cart"></i>
                                                    <sup><?php echo e($cartCount ?? 0); ?></sup>
                                                </span>
                                                <h6>
                                                    <span>Your Cart</span>
                                                    <span
                                                        class="ltn__secondary-color">$<?php echo e(number_format($cartTotal ?? 0, 2)); ?></span>
                                                </h6>
                                            </a>
                                        </div>
                                    </li>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Desktop Nav -->
            <div
                class="header-bottom-area ltn__border-top ltn__header-sticky ltn__sticky-bg-secondary ltn__secondary-bg section-bg-1 menu-color-white d-none d-lg-block">
                <div class="container">
                    <div class="row">
                        <div class="col header-menu-column justify-content-center">
                            <div class="sticky-logo">
                                <div class="site-logo">
                                    <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('img/ntgreen.jpeg')); ?>"
                                            alt="Logo"></a>
                                </div>
                            </div>
                            <div class="header-menu header-menu-2">
                                <nav>
                                    <div class="ltn__main-menu">
                                        <ul>
                                            <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                                            <li><a href="<?php echo e(route('shop')); ?>">Shop</a></li>
                                            <li><a href="<?php echo e(route('shop')); ?>">Drugs</a></li>
                                        </ul>
                                    </div>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <!-- Mobile Menu Toggle -->
        <div class="mobile-header-menu-fullwidth mb-30 d-block d-lg-none">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="mobile-menu-toggle d-lg-none">
                            <span>MENU</span>
                            <a href="#ltn__utilize-mobile-menu" class="ltn__utilize-toggle" id="mobile-menu-trigger">
                                <svg viewBox="0 0 800 600">
                                    <path
                                        d="M300,220 C300,220 520,220 540,220 C740,220 640,540 520,420 C440,340 300,200 300,200"
                                        id="top"></path>
                                    <path d="M300,320 L540,320" id="middle"></path>
                                    <path
                                        d="M300,210 C300,210 520,210 540,210 C740,210 640,530 520,410 C440,330 300,190 300,190"
                                        id="bottom"
                                        transform="translate(480, 320) scale(1, -1) translate(-480, -318)"></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Mobile Menu Drawer -->
        <div id="ltn__utilize-mobile-menu" class="ltn__utilize ltn__utilize-mobile-menu">
            <div class="ltn__utilize-menu-inner ltn__scrollbar">
                <div class="ltn__utilize-menu-head">
                    <div class="site-logo">
                        <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('img/ntc_logo.png')); ?>"
                                alt="Logo"></a>
                    </div>
                    <button class="ltn__utilize-close">×</button>
                </div>
                <div class="ltn__utilize-menu-search-form">
                    <form action="<?php echo e(route('shop')); ?>" method="GET">
                        <input type="text" name="search" placeholder="Search...">
                        <button type="submit"><i class="fas fa-search"></i></button>
                    </form>
                </div>
                <div class="ltn__utilize-menu">
                    <ul>
                        <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li><a href="<?php echo e(route('shop')); ?>">Shop</a></li>
                        <?php if(auth()->guard()->check()): ?>
                            <li><a href="<?php echo e(route('orders.index')); ?>">My Orders</a></li>
                            <li>
                                <form method="POST" action="<?php echo e(route('logout')); ?>" style="padding: 15px 30px;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="logout-btn">Logout</button>
                                </form>
                            </li>
                        <?php else: ?>
                            <li><a href="<?php echo e(route('login')); ?>">Login</a></li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="ltn__utilize-buttons ltn__utilize-buttons-2">
                    <ul>
                        <li>
                            <a href="<?php echo e(route('cart.index')); ?>" title="Shopping Cart">
                                <span class="utilize-btn-icon">
                                    <i class="fas fa-shopping-cart"></i>
                                    <sup><?php echo e($cartCount ?? 0); ?></sup>
                                </span>
                                Cart &mdash; $<?php echo e(number_format($cartTotal ?? 0, 2)); ?>

                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="ltn__utilize-overlay"></div>

        <?php echo $__env->yieldContent('content'); ?>

        <!-- FOOTER -->
        <footer class="ltn__footer-area">
            <div class="footer-top-area section-bg-2 plr--5">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xl-3 col-md-6 col-sm-6 col-12">
                            <div class="footer-widget footer-about-widget">
                                <div class="footer-logo">
                                    <div class="site-logo"><img src="<?php echo e(asset('img/ntgreen.jpeg')); ?>"
                                            alt="Logo"></div>
                                </div>
                                <p>Your trusted source for quality health and pharmaceutical products.</p>


                            </div>
                        </div>
                        <div class="col-xl-2 col-md-6 col-sm-6 col-12">
                            <div class="footer-widget footer-menu-widget clearfix">
                                <h4 class="footer-title">Services</h4>
                                <div class="footer-menu">
                                    <ul>
                                        <li><a href="<?php echo e(route('orders.index')); ?>">Order Tracking</a></li>
                                        <li><a href="#">My Account</a></li>
                                        <li><a href="#">Terms & Conditions</a></li>
                                        <li><a href="#">Promotional Offers</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-2 col-md-6 col-sm-6 col-12">
                            <div class="footer-widget footer-menu-widget clearfix">
                                <h4 class="footer-title">Customer Care</h4>
                                <div class="footer-menu">
                                    <ul>
                                        <li><a href="#">My Account</a></li>
                                        <li><a href="<?php echo e(route('orders.index')); ?>">Order Tracking</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <div class="ltn__copyright-area ltn__copyright-2 section-bg-7 plr--5">
                <div class="container-fluid ltn__border-top-2">
                    <div class="row">
                        <div class="col-md-6 col-12">
                            <div class="ltn__copyright-design clearfix">
                                <p>All Rights Reserved @ Notrace Trip <span
                                        class="current-year"><?php echo e(date('Y')); ?></span></p>
                            </div>
                        </div>
                        <div class="col-md-6 col-12 align-self-center">
                            <div class="ltn__copyright-menu text-end">
                                <ul>
                                    <li><a href="#">Terms & Conditions</a></li>
                                    <li><a href="#">Claim</a></li>
                                    <li><a href="#">Privacy & Policy</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </footer>

    </div><!-- /.body-wrapper -->

    <div class="preloader d-none" id="preloader">
        <div class="preloader-inner">
            <div class="spinner">
                <div class="dot1"></div>
                <div class="dot2"></div>
            </div>
        </div>
    </div>

    <!-- ADD TO CART SUCCESS MODAL -->
    <div class="modal fade" id="add_to_cart_modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center p-4">
                        <div class="modal-product-img mb-3">
                            <img id="cart-modal-image" src="" alt="Product"
                                style="max-width:150px; border-radius:8px;">
                        </div>
                        <h5 id="cart-modal-name" class="mb-2"></h5>
                        <p style="color:#0a9a73; font-weight:600;">
                            <i class="fas fa-check-circle"></i> Added to cart successfully!
                        </p>
                        <div class="d-flex gap-2 justify-content-center mt-3">
                            <a href="<?php echo e(route('shop')); ?>" class="theme-btn-2 btn btn-effect-2">Continue Shopping</a>
                            <a href="<?php echo e(route('cart.index')); ?>" class="theme-btn-1 btn btn-effect-1">View Cart</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- WISHLIST MODAL -->
    <div class="modal fade" id="liton_wishlist_modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center p-4">
                        <div class="modal-product-img mb-3">
                            <img id="wishlist-modal-image" src="" alt="Product"
                                style="max-width:150px; border-radius:8px;">
                        </div>
                        <h5 id="wishlist-modal-name" class="mb-2"></h5>
                        <p style="color:#0a9a73; font-weight:600;">
                            <i class="fas fa-heart"></i> Added to wishlist!
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="<?php echo e(asset('js/plugins.js')); ?>"></script>
    <script src="<?php echo e(asset('js/main.js')); ?>"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {

            // ── Block plugins.js from hijacking the cart icon (capture phase) ────────
            const cartWrap = document.getElementById('header-cart-wrap');
            if (cartWrap) {
                cartWrap.addEventListener('click', function(e) {
                    e.stopImmediatePropagation();
                }, true);
            }

            // ── Mobile Menu — MENU button only ───────────────────────────────────────
            const menuTrigger = document.getElementById('mobile-menu-trigger');
            const mobileMenu = document.getElementById('ltn__utilize-mobile-menu');
            const overlay = document.querySelector('.ltn__utilize-overlay');
            const closeBtn = document.querySelector('#ltn__utilize-mobile-menu .ltn__utilize-close');

            if (menuTrigger && mobileMenu) {
                menuTrigger.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopImmediatePropagation();
                    mobileMenu.classList.add('ltn__utilize-open');
                    if (overlay) overlay.classList.add('ltn__utilize-open');
                    document.body.style.overflow = 'hidden';
                }, true);
            }

            if (closeBtn) {
                closeBtn.addEventListener('click', function() {
                    mobileMenu.classList.remove('ltn__utilize-open');
                    if (overlay) overlay.classList.remove('ltn__utilize-open');
                    document.body.style.overflow = '';
                });
            }

            if (overlay) {
                overlay.addEventListener('click', function() {
                    mobileMenu.classList.remove('ltn__utilize-open');
                    overlay.classList.remove('ltn__utilize-open');
                    document.body.style.overflow = '';
                });
            }
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>

</body>

</html>
<?php /**PATH /Users/ozil/notrace/resources/views/layouts/app.blade.php ENDPATH**/ ?>