<?php $__env->startSection('content'); ?>

    <div class="ltn__breadcrumb-area text-left bg-overlay-white-30 bg-image" data-bs-bg="<?php echo e(asset('img/bg/14.jpg')); ?>">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ltn__breadcrumb-inner">
                        <h1 class="page-title">Checkout</h1>
                        <div class="ltn__breadcrumb-list">
                            <ul>
                                <li><a href="<?php echo e(route('home')); ?>"><span class="ltn__secondary-color"><i
                                                class="fas fa-home"></i></span> Home</a></li>
                                <li><a href="<?php echo e(route('cart.index')); ?>">Cart</a></li>
                                <li>Checkout</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="ltn__checkout-area mb-120 mt-60">
        <div class="container">
            <div class="row">
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger mb-4">
                        <ul style="margin: 0; padding-left: 20px;">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <!-- BILLING DETAILS -->
                <div class="col-lg-7">
                    <div class="ltn__checkout-inner">
                        <h4 class="title-2 mb-30">Billing Details</h4>

                        <form action="<?php echo e(route('checkout.place')); ?>" method="POST" id="checkout-form">
                            <?php echo csrf_field(); ?>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="input-item mb-3">
                                        <label>First Name <span class="text-danger">*</span></label>
                                        <input type="text" name="first_name" class="form-control"
                                            value="<?php echo e(old('first_name', auth()->user()->name ?? '')); ?>" required>
                                        <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="input-item mb-3">
                                        <label>Last Name <span class="text-danger">*</span></label>
                                        <input type="text" name="last_name" class="form-control"
                                            value="<?php echo e(old('last_name')); ?>" required>
                                        <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>

                            <div class="input-item mb-3">
                                <label>Email Address <span class="text-danger">*</span></label>
                                <input type="email" name="email" class="form-control"
                                    value="<?php echo e(old('email', auth()->user()->email ?? '')); ?>" required>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="input-item mb-3">
                                <label>Phone Number <span class="text-danger">*</span></label>
                                <input type="text" name="phone" class="form-control" value="<?php echo e(old('phone')); ?>"
                                    required>
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="input-item mb-3">
                                <label>Street Address <span class="text-danger">*</span></label>
                                <input type="text" name="address" class="form-control"
                                    placeholder="House number and street name" value="<?php echo e(old('address')); ?>" required>
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="input-item mb-3">
                                <label>Apartment, suite, unit (optional)</label>
                                <input type="text" name="address2" class="form-control" value="<?php echo e(old('address2')); ?>">
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="input-item mb-3">
                                        <label>City <span class="text-danger">*</span></label>
                                        <input type="text" name="city" class="form-control"
                                            value="<?php echo e(old('city')); ?>" required>
                                        <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="input-item mb-3">
                                        <label>State / Province</label>
                                        <input type="text" name="state" class="form-control"
                                            value="<?php echo e(old('state')); ?>">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="input-item mb-3">
                                        <label>ZIP / Postal Code</label>
                                        <input type="text" name="zip" class="form-control"
                                            value="<?php echo e(old('zip')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="input-item mb-3">
                                        <label>Country <span class="text-danger">*</span></label>
                                        <input type="text" name="country" class="form-control"
                                            value="<?php echo e(old('country')); ?>" required>
                                        <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>

                            <div class="input-item mb-3">
                                <label>Order Notes (optional)</label>
                                <textarea name="notes" class="form-control" rows="4"
                                    placeholder="Notes about your order, e.g. special delivery instructions."><?php echo e(old('notes')); ?></textarea>
                            </div>

                            <!-- Hidden shipping fields (set by JS) -->
                            <input type="hidden" name="shipping_type" id="hidden-shipping-type"
                                value="<?php echo e(session('shipping_type', 'shipping_discrete')); ?>">
                            <input type="hidden" name="shipping_cost" id="hidden-shipping-cost"
                                value="<?php echo e(session('shipping_cost', 30)); ?>">

                    </div><!-- /.ltn__checkout-inner -->
                </div>

                <!-- ORDER SUMMARY -->
                <div class="col-lg-5">
                    <div class="shoping-cart-total" style="background:#f8f8f8; padding:30px; border-radius:10px;">
                        <h4 class="mb-4">Your Order</h4>

                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th class="text-end">Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $cartItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $price =
                                            $item->product->is_on_sale && $item->product->discount_price
                                                ? $item->product->discount_price
                                                : $item->product->price;
                                    ?>
                                    <tr>
                                        <td>
                                            <?php echo e($item->product->name); ?>

                                            <strong class="text-muted"> × <?php echo e($item->quantity); ?></strong>
                                        </td>
                                        <td class="text-end">$<?php echo e(number_format($price * $item->quantity, 2)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                        <hr>

                        <!-- Shipping Selection -->
                        <div class="mb-3">
                            <strong>Shipping Method</strong>
                            <div class="mt-2">
                                <div class="form-check">
                                    <input class="form-check-input shipping-radio" type="radio" name="shipping_display"
                                        id="co_discrete" value="30"
                                        <?php echo e(session('shipping_type', 'shipping_discrete') === 'shipping_discrete' ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="co_discrete">
                                        Discrete Shipping — <strong>$30.00</strong>
                                        <small class="d-block text-muted">Plain packaging, no labels</small>
                                    </label>
                                </div>
                                <div class="form-check mt-2">
                                    <input class="form-check-input shipping-radio" type="radio" name="shipping_display"
                                        id="co_non_discrete" value="60"
                                        <?php echo e(session('shipping_type') === 'shipping_non_discrete' ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="co_non_discrete">
                                        Non-Discrete Shipping — <strong>$60.00</strong>
                                        <small class="d-block text-muted">Standard packaging</small>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <table class="table">
                            <tbody>
                                <tr>
                                    <td>Subtotal</td>
                                    <td class="text-end">$<?php echo e(number_format($subtotal, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Shipping</td>
                                    <td class="text-end" id="co-shipping-display">
                                        $<?php echo e(number_format(session('shipping_cost', 30), 2)); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td>VAT</td>
                                    <td class="text-end">$0.00</td>
                                </tr>
                                <tr>
                                    <td><strong>Order Total</strong></td>
                                    <td class="text-end">
                                        <strong id="co-order-total">
                                            $<?php echo e(number_format($subtotal + session('shipping_cost', 30), 2)); ?>

                                        </strong>
                                    </td>
                                </tr>
                            </tbody>
                        </table>

                        <hr>

                        <!-- Payment Method -->
                        <div class="mb-4">
                            <strong>Payment Method</strong>
                            <div class="mt-2">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="payment_method" id="pay_bank"
                                        value="gift_card" checked>
                                    <label class="form-check-label" for="pay_bank">
                                        Gift Card
                                    </label>
                                </div>
                                <div class="form-check mt-1">
                                    <input class="form-check-input" type="radio" name="payment_method" id="pay_crypto"
                                        value="crypto">
                                    <label class="form-check-label" for="pay_crypto">
                                        Cryptocurrency
                                    </label>
                                </div>

                            </div>
                        </div>

                        <button type="submit" form="checkout-form" class="theme-btn-1 btn btn-effect-1 w-100">
                            <i class="fas fa-lock me-2"></i> Place Order
                        </button>

                    </div>
                </div>
                </form>

            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const csrf = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
                const subtotal = <?php echo e($subtotal); ?>;

                document.querySelectorAll('.shipping-radio').forEach(radio => {
                    radio.addEventListener('change', function() {
                        const cost = parseFloat(this.value);
                        const type = this.id === 'co_discrete' ? 'shipping_discrete' :
                            'shipping_non_discrete';

                        // Update display
                        document.getElementById('co-shipping-display').textContent = '$' + cost.toFixed(
                            2);
                        document.getElementById('co-order-total').textContent = '$' + (subtotal + cost)
                            .toFixed(2);

                        // Update hidden fields for form submission
                        document.getElementById('hidden-shipping-type').value = type;
                        document.getElementById('hidden-shipping-cost').value = cost;

                        // Save to session
                        fetch('/cart/shipping', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': csrf,
                                'Accept': 'application/json'
                            },
                            body: JSON.stringify({
                                shipping_type: type,
                                shipping_cost: cost
                            })
                        });
                    });
                });
            });
        </script>
    <?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/ozil/notrace/resources/views/checkout.blade.php ENDPATH**/ ?>